/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.event.PropagationEvent;
import choco.kernel.solver.propagation.queue.EventQueue;
import java.util.ArrayDeque;
import java.util.Queue;

public class VariableEventQueue
implements EventQueue {
    protected Queue<PropagationEvent> queue = new ArrayDeque<PropagationEvent>();
    protected PropagationEvent lastPopped = null;

    @Override
    public void clear() {
        this.queue.clear();
        this.lastPopped = null;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void propagateAllEvents() throws ContradictionException {
        while (this.queue.size() != 0) {
            PropagationEvent evt = this.popEvent();
            evt.propagateEvent();
        }
    }

    @Override
    public void propagateOneEvent() throws ContradictionException {
        if (this.queue.size() != 0) {
            this.popEvent().propagateEvent();
        }
    }

    @Override
    public PropagationEvent popEvent() {
        PropagationEvent event;
        this.lastPopped = event = this.queue.poll();
        return event;
    }

    @Override
    public boolean pushEvent(PropagationEvent event) {
        this.queue.add(event);
        return true;
    }

    @Override
    public void flushEventQueue() {
        if (null != this.lastPopped) {
            this.lastPopped.clear();
        }
        while (!this.queue.isEmpty()) {
            this.queue.remove().clear();
        }
    }

    @Override
    public boolean remove(PropagationEvent event) {
        return this.queue.remove(event);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public PropagationEvent get(int idx) {
        for (PropagationEvent event : this.queue) {
            if (idx == 0) {
                return event;
            }
            --idx;
        }
        return null;
    }
}

