/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.kernel.common.IDotty;
import choco.kernel.model.constraints.ITemporalRelation;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.BitSet;

public class DisjunctiveGraph<E extends ITemporalRelation<?, ?>>
implements IDotty {
    public final int nbNodes;
    protected int nbArcs = 0;
    protected int nbEdges = 0;
    private BitSet[] savedPrecGraph;
    protected final BitSet[] precGraph;
    protected final BitSet[] disjGraph;
    protected final TIntIntHashMap setupTimes;
    public final TIntObjectHashMap<E> storedConstraints;
    protected static final String ARC_COLOR = "color=forestgreen";
    protected static final String EDGE_COLOR = "color=royalblue";
    protected static final String STY_BOLD_DASHED = "style=\"bold,dashed\"";
    protected static final String STY_BOLD = "style=bold";
    protected static final String ARROW_DOT = "arrowhead=dot";
    protected static final String ARROW_BIG = "arrowsize=1.5";
    protected static final String DIR_BWD = "dir=back";

    public DisjunctiveGraph(int n) {
        this.precGraph = new BitSet[n];
        this.disjGraph = new BitSet[n];
        this.setupTimes = new TIntIntHashMap();
        for (int i = 0; i < n; ++i) {
            this.precGraph[i] = new BitSet(n);
            this.disjGraph[i] = new BitSet(n);
        }
        this.nbNodes = n;
        this.storedConstraints = new TIntObjectHashMap();
    }

    public final int getNbNodes() {
        return this.nbNodes;
    }

    public final int getNbArcs() {
        return this.nbArcs;
    }

    public final int getNbEdges() {
        return this.nbEdges;
    }

    public final int getKey(int i, int j) {
        return i * this.nbNodes + j;
    }

    public final boolean isEmpty() {
        return this.nbArcs == 0 && this.nbEdges == 0;
    }

    protected final void setPrecClosure() {
        this.savedPrecGraph = DisjunctiveGraph.copy(this.precGraph);
        DisjunctiveGraph.floydMarshallClosure(this.precGraph);
    }

    protected final void unsetPrecClosure() {
        if (this.savedPrecGraph != null) {
            for (int i = 0; i < this.savedPrecGraph.length; ++i) {
                this.precGraph[i] = this.savedPrecGraph[i];
            }
        }
    }

    public final BitSet[] copyPrecGraph() {
        return DisjunctiveGraph.copy(this.precGraph);
    }

    public final BitSet[] getPrecClosure() {
        return DisjunctiveGraph.getClosure(this.precGraph);
    }

    public static final BitSet[] copy(BitSet[] graph) {
        BitSet[] res = new BitSet[graph.length];
        for (int i = 0; i < graph.length; ++i) {
            res[i] = (BitSet)graph[i].clone();
        }
        return res;
    }

    public static final BitSet[] getClosure(BitSet[] graph) {
        BitSet[] closure = DisjunctiveGraph.copy(graph);
        DisjunctiveGraph.floydMarshallClosure(closure);
        return closure;
    }

    public static final void floydMarshallClosure(BitSet[] graph) {
        for (int k = 0; k < graph.length; ++k) {
            for (int i = 0; i < graph.length; ++i) {
                if (!graph[i].get(k)) continue;
                graph[i].or(graph[k]);
            }
        }
    }

    public static final BitSet[] getReduction(BitSet[] graph) {
        BitSet[] reduction = DisjunctiveGraph.getClosure(graph);
        DisjunctiveGraph.floydMarshallReduction(reduction);
        return reduction;
    }

    public static final void floydMarshallReduction(BitSet[] graph) {
        for (int k = 0; k < graph.length; ++k) {
            for (int i = 0; i < graph.length; ++i) {
                if (!graph[i].get(k)) continue;
                graph[i].andNot(graph[k]);
            }
        }
    }

    public static final BitSet[] getTransitive(BitSet[] graph) {
        BitSet[] reduction = DisjunctiveGraph.getReduction(graph);
        BitSet[] transitive = DisjunctiveGraph.copy(graph);
        DisjunctiveGraph.andNot(transitive, reduction);
        return transitive;
    }

    public static final void andNot(BitSet[] graph, BitSet[] reduction) {
        for (int i = 0; i < graph.length; ++i) {
            graph[i].andNot(reduction[i]);
        }
    }

    public final void addArc(int i, int j, int setupTime) {
        this.precGraph[i].set(j);
        int key = this.getKey(i, j);
        this.setupTimes.put(key, setupTime);
        ++this.nbArcs;
    }

    public final void addArc(int i, int j, int setupTime, E rel) {
        this.precGraph[i].set(j);
        int key = this.getKey(i, j);
        this.storedConstraints.put(key, rel);
        this.setupTimes.put(key, setupTime);
        ++this.nbArcs;
    }

    protected void deleteArc(int i, int j) {
        if (this.precGraph[i].get(j)) {
            this.precGraph[i].clear(j);
            int key = this.getKey(i, j);
            this.storedConstraints.remove(key);
            this.setupTimes.remove(key);
            ++this.nbArcs;
        }
    }

    public final void safeAddArc(int i, int j, int setupTime) {
        if (setupTime >= 0) {
            this.addArc(i, j, setupTime);
        }
    }

    public final void addEdge(int i, int j, E rel) {
        this.addEdge(i, j, rel.forwardSetup(), rel.backwardSetup(), rel);
    }

    protected final void addEdge(int i, int j, int forwardSetup, int backwardSetup, E rel) {
        this.disjGraph[i].set(j);
        this.disjGraph[j].set(i);
        int key = this.getKey(i, j);
        this.storedConstraints.put(key, rel);
        this.setupTimes.put(key, forwardSetup);
        this.setupTimes.put(this.getKey(j, i), backwardSetup);
        ++this.nbEdges;
    }

    public final boolean isFixed() {
        return this.storedConstraints.forEachValue(new TObjectProcedure<E>(){

            @Override
            public boolean execute(E arg0) {
                return arg0.isFixed();
            }
        });
    }

    public final int setupTime(int i, int j) {
        return this.setupTimes.get(this.getKey(i, j));
    }

    public final boolean containsArc(int i, int j) {
        return this.precGraph[i].get(j);
    }

    public final boolean containsEdge(int i, int j) {
        return this.disjGraph[i].get(j);
    }

    public final boolean containsRelation(int i, int j) {
        return this.containsArc(i, j) || this.containsArc(j, i) || this.containsEdge(i, j);
    }

    public final boolean containsConstraint(int i, int j) {
        return this.storedConstraints.contains(this.getKey(i, j));
    }

    public final E getConstraint(int i, int j) {
        return (E)((ITemporalRelation)this.storedConstraints.get(this.getKey(i, j)));
    }

    public final E getEdgeConstraint(int i, int j) {
        ITemporalRelation cij = (ITemporalRelation)this.storedConstraints.get(this.getKey(i, j));
        return (E)(cij == null ? (ITemporalRelation)this.storedConstraints.get(this.getKey(j, i)) : cij);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                if (this.precGraph[i].get(j)) {
                    s.append("o ");
                    continue;
                }
                if (this.disjGraph[i].get(j)) {
                    s.append("x ");
                    continue;
                }
                s.append(". ");
            }
            s.append("\n");
        }
        return s.toString();
    }

    public final String setupTimesToString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.nbNodes; ++i) {
            for (int j = 0; j < this.nbNodes; ++j) {
                if (this.precGraph[i].get(j) || this.disjGraph[i].get(j)) {
                    s.append(this.setupTimes.get(this.getKey(i, j))).append(' ');
                    continue;
                }
                s.append(". ");
            }
            s.append("\n");
        }
        return s.toString();
    }

    protected final String getArcLabel(int i, int j) {
        int st = this.setupTime(i, j);
        return st > 0 ? "label=\"" + st + '\"' : null;
    }

    protected final String getEdgeLabel(int i, int j) {
        int st1 = this.setupTime(i, j);
        int st2 = this.setupTime(j, i);
        return st1 > 0 || st2 > 0 ? "label=\"(" + st1 + ", " + st2 + ")\"" : null;
    }

    private final void writeArc(StringBuilder b, int i, int j) {
        b.append(i).append(" -> ").append(j);
    }

    protected void writeAttributes(StringBuilder b, String ... options) {
        b.append(" [");
        int l1 = b.length();
        for (String opt : options) {
            if (opt == null || opt.isEmpty()) continue;
            b.append(' ').append(opt).append(',');
        }
        int l2 = b.length();
        if (l2 > l1) {
            b.replace(l2 - 1, l2, "];\n");
        } else {
            b.deleteCharAt(l1 - 1);
        }
    }

    protected void writeArcAttributes(StringBuilder b, int i, int j) {
        this.writeAttributes(b, ARC_COLOR, STY_BOLD, this.getArcLabel(i, j));
    }

    protected void writeEdge(StringBuilder b, E rel, int i, int j) {
        if (rel.isFixed() && rel.getDirVal() == 0) {
            this.writeArc(b, j, i);
        } else {
            this.writeArc(b, i, j);
        }
    }

    protected void writeEdgeAttributes(StringBuilder b, E rel, int i, int j) {
        if (rel.isFixed()) {
            this.writeAttributes(b, EDGE_COLOR, STY_BOLD, ARROW_BIG, rel.getDirVal() == 1 ? this.getArcLabel(i, j) : this.getArcLabel(j, i));
        } else {
            this.writeAttributes(b, EDGE_COLOR, STY_BOLD_DASHED, ARROW_BIG, ARROW_DOT, this.getEdgeLabel(i, j));
        }
    }

    protected StringBuilder toDottyNodes() {
        return new StringBuilder();
    }

    @Override
    public final String toDotty() {
        StringBuilder b = this.toDottyNodes();
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.precGraph[i].nextSetBit(0);
            while (j >= 0) {
                this.writeArc(b, i, j);
                this.writeArcAttributes(b, i, j);
                j = this.precGraph[i].nextSetBit(j + 1);
            }
            j = this.disjGraph[i].nextSetBit(0);
            while (j >= 0) {
                ITemporalRelation rel = (ITemporalRelation)this.storedConstraints.get(this.getKey(i, j));
                if (rel != null) {
                    this.writeEdge(b, rel, i, j);
                    this.writeEdgeAttributes(b, rel, i, j);
                }
                j = this.disjGraph[i].nextSetBit(j + 1);
            }
        }
        return b.toString();
    }
}

