/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimStatus;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.ThetaTreeLeaf;
import choco.cp.solver.constraints.global.scheduling.trees.status.ThetaStatus;
import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.List;

public final class DisjTreeT
extends AbstractThetaTree {
    public DisjTreeT(List<? extends ITask> tasks) {
        super(tasks);
    }

    @Override
    public void insert(ITask task) {
        this.insertTask(task, new DisjStatusT(AbstractVilimTree.NodeType.NIL), new DisjStatusT(AbstractVilimTree.NodeType.INTERNAL));
    }

    @Override
    public int getTime() {
        return ((ThetaStatus)((DisjStatusT)this.getRoot().getNodeStatus()).getStatus()).getTime();
    }

    final class DisjStatusT
    extends AbstractVilimStatus<ThetaStatus>
    implements ThetaTreeLeaf {
        public DisjStatusT(AbstractVilimTree.NodeType type) {
            super(type, new ThetaStatus());
        }

        @Override
        public void insertInTheta() {
            this.setType(AbstractVilimTree.NodeType.THETA);
            ((ThetaStatus)this.getStatus()).setTime(DisjTreeT.this.getMode().value() ? this.task.getEST() + this.task.getMinDuration() : this.task.getLCT() - this.task.getMinDuration());
            ((ThetaStatus)this.getStatus()).setDuration(this.task.getMinDuration());
        }

        @Override
        public void insertInTheta(IRTask rtask) {
            this.insertInTheta();
        }

        @Override
        public void removeFromTheta() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaStatus)this.getStatus()).setTime(this.getResetIntValue(DisjTreeT.this.getMode()));
            ((ThetaStatus)this.getStatus()).setDuration(0);
        }

        @Override
        public void reset() {
            this.removeFromTheta();
        }

        @Override
        protected void writeDotStatus(StringBuilder buffer) {
            this.writeRow(buffer, DisjTreeT.this.getMode().label(), this.format(((ThetaStatus)this.status).getTime()), "P", String.valueOf(((ThetaStatus)this.status).getDuration()));
        }

        @Override
        public void updateInternalNode(IBinaryNode node) {
            if (node.getLeftChild().getNodeStatus() instanceof DisjStatusT) {
                ThetaStatus left = (ThetaStatus)((DisjStatusT)node.getLeftChild().getNodeStatus()).getStatus();
                if (node.getRightChild().getNodeStatus() instanceof DisjStatusT) {
                    ThetaStatus right = (ThetaStatus)((DisjStatusT)node.getRightChild().getNodeStatus()).getStatus();
                    ((ThetaStatus)this.status).update(DisjTreeT.this.getMode(), left, right);
                    return;
                }
            }
            throw new SolverException("cant update node");
        }
    }
}

