/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractMixedSetIntSConstraint;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public final class AmongSet
extends AbstractMixedSetIntSConstraint {
    private final int nb_vars;
    private final IntDomainVar[] ivars;
    private final SetVar s;
    private final IntDomainVar n;
    private final int idxS;
    int[] bothK = new int[10];
    int kIdx = 0;
    int[] bothE = new int[10];
    int eIdx = 0;
    int envInf;
    int[][] lb_ub;
    int min;
    int max;
    IStateBitSet outKinE;
    IStateBitSet inKer;
    IStateBitSet inEnv;
    IStateBitSet outKer;
    IStateBitSet outEnv;
    IStateBitSet varToUpdate;
    private final IEnvironment environment;

    public AmongSet(Var[] vars, IEnvironment environment) {
        super(vars);
        this.nb_vars = vars.length - 2;
        this.ivars = new IntDomainVar[this.nb_vars];
        System.arraycopy(vars, 0, this.ivars, 0, this.nb_vars);
        this.s = (SetVar)vars[this.nb_vars];
        this.idxS = this.nb_vars;
        this.n = (IntDomainVar)vars[this.nb_vars + 1];
        this.environment = environment;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == this.idxS) {
            return 7;
        }
        return 4;
    }

    private void init() {
        int envSize = this.s.getEnveloppeDomainSize();
        this.envInf = this.s.getEnveloppeInf();
        this.outKinE = this.environment.makeBitSet(envSize);
        this.inKer = this.environment.makeBitSet(this.nb_vars);
        this.outKer = this.environment.makeBitSet(this.nb_vars);
        this.inEnv = this.environment.makeBitSet(this.nb_vars);
        this.outEnv = this.environment.makeBitSet(this.nb_vars);
        this.varToUpdate = this.environment.makeBitSet(this.nb_vars);
        this.lb_ub = new int[3][envSize];
        DisposableIntIterator it = this.s.getDomain().getEnveloppeIterator();
        while (it.hasNext()) {
            int val;
            this.outKinE.set(val - this.envInf, !this.s.isInDomainKernel(val = it.next()));
        }
        it.dispose();
        this.computeForAllVar();
    }

    private void computeForAllVar() {
        for (int i = 0; i < this.nb_vars; ++i) {
            this.computeForVar(i);
        }
    }

    private void computeForVar(int i) {
        IntDomainVar var = this.ivars[i];
        int dSize = var.getDomainSize();
        int nbK = 0;
        int nbE = 0;
        DisposableIntIterator it = this.s.getDomain().getEnveloppeIterator();
        while (it.hasNext()) {
            int val = it.next();
            boolean contain = var.canBeInstantiatedTo(val);
            nbE += contain ? 1 : 0;
            if (!this.s.isInDomainKernel(val)) continue;
            nbK += contain ? 1 : 0;
        }
        it.dispose();
        if (nbK == dSize) {
            this.inKer.set(i, true);
            this.outKer.set(i, false);
        } else if (nbK == 0) {
            this.inKer.set(i, false);
            this.outKer.set(i, true);
        } else {
            this.inKer.set(i, false);
            this.outKer.set(i, false);
        }
        if (nbE == dSize) {
            this.inEnv.set(i, true);
            this.outEnv.set(i, false);
        } else if (nbE == 0) {
            this.inEnv.set(i, false);
            this.outEnv.set(i, true);
        } else {
            this.inEnv.set(i, false);
            this.outEnv.set(i, false);
        }
        this.varToUpdate.set(i, false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.init();
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        int v = this.varToUpdate.nextSetBit(0);
        while (v >= 0) {
            this.computeForVar(v);
            v = this.varToUpdate.nextSetBit(v + 1);
        }
        this.computeBounds();
        this.updateN();
        this.updateSet();
        this.filter();
    }

    private void filter() throws ContradictionException {
        if (this.n.isInstantiated()) {
            int val;
            int left;
            int right;
            IntDomainVar v;
            int i;
            int j;
            DisposableIntIterator it = null;
            int[] lb_ub = this.computeLastBounds();
            if (lb_ub[0] == this.n.getInf()) {
                for (j = 0; j < this.kIdx; ++j) {
                    i = this.bothK[j];
                    v = this.ivars[i];
                    right = Integer.MIN_VALUE;
                    left = Integer.MIN_VALUE;
                    it = this.s.getDomain().getKernelIterator();
                    while (it.hasNext()) {
                        val = it.next();
                        if (val == right + 1) {
                            right = val;
                            continue;
                        }
                        v.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                    v.removeInterval(left, right, this, false);
                    it.dispose();
                }
            }
            if (lb_ub[1] == this.n.getSup()) {
                for (j = 0; j < this.eIdx; ++j) {
                    i = this.bothE[j];
                    v = this.ivars[i];
                    right = Integer.MIN_VALUE;
                    left = Integer.MIN_VALUE;
                    it = v.getDomain().getIterator();
                    while (it.hasNext()) {
                        val = it.next();
                        if (this.s.isInDomainEnveloppe(val)) continue;
                        if (val == right + 1) {
                            right = val;
                            continue;
                        }
                        v.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                    v.removeInterval(left, right, this, false);
                    it.dispose();
                }
            }
        }
    }

    private void updateN() throws ContradictionException {
        int lb0 = this.inKer.cardinality();
        int glb0 = this.nb_vars - this.outKer.cardinality();
        int ub0 = this.nb_vars - this.outEnv.cardinality();
        int lub0 = this.inEnv.cardinality();
        if (glb0 < this.n.getInf()) {
            if (this.min < Integer.MAX_VALUE) {
                this.n.updateInf(this.min, this, false);
            }
        } else {
            this.n.updateInf(lb0, this, false);
        }
        if (lub0 > this.n.getSup()) {
            if (this.max > Integer.MIN_VALUE) {
                this.n.updateSup(this.max, this, false);
            }
        } else {
            this.n.updateSup(ub0, this, false);
        }
    }

    private void updateSet() throws ContradictionException {
        int idx = 0;
        boolean mod = false;
        int e = this.outKinE.nextSetBit(0);
        while (e >= 0) {
            if (this.lb_ub[1][idx] < this.n.getInf()) {
                mod |= this.s.addToKernel(this.lb_ub[2][idx], this, false);
                this.outKinE.set(e, false);
            }
            if (this.lb_ub[0][idx] > this.n.getSup()) {
                mod |= this.s.remFromEnveloppe(this.lb_ub[2][idx], this, false);
                this.outKinE.set(e, false);
            }
            ++idx;
            e = this.outKinE.nextSetBit(e + 1);
        }
        if (mod) {
            this.computeForAllVar();
        }
    }

    private int[] computeLastBounds() {
        this.kIdx = 0;
        this.eIdx = 0;
        int lb = this.nb_vars;
        int ub = 0;
        for (int i = 0; i < this.nb_vars; ++i) {
            IntDomainVar var = this.ivars[i];
            if (!this.inKer.get(i)) {
                lb += this.updateLB(var, i);
            }
            if (this.outEnv.get(i)) continue;
            ub += this.updateUB(var, i);
        }
        return new int[]{lb, ub};
    }

    private int updateLB(IntDomainVar var, int i) {
        if (var.getDomainSize() <= this.s.getKernelDomainSize()) {
            DisposableIntIterator it = var.getDomain().getIterator();
            while (it.hasNext()) {
                int val = it.next();
                if (this.s.isInDomainKernel(val)) continue;
                this.ensureCapacity(this.bothK, this.kIdx);
                this.bothK[this.kIdx++] = i;
                it.dispose();
                return -1;
            }
            it.dispose();
            return 0;
        }
        this.ensureCapacity(this.bothK, this.kIdx);
        this.bothK[this.kIdx++] = i;
        return -1;
    }

    private int updateUB(IntDomainVar var, int i) {
        DisposableIntIterator it = this.s.getDomain().getEnveloppeIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (!var.canBeInstantiatedTo(val)) continue;
            this.ensureCapacity(this.bothE, this.eIdx);
            this.bothE[this.eIdx++] = i;
            it.dispose();
            return 1;
        }
        it.dispose();
        return 0;
    }

    private void computeBounds() {
        int idx = 0;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        int e = this.outKinE.nextSetBit(0);
        while (e >= 0) {
            int val = e + this.envInf;
            int lb = this.inKer.cardinality();
            int ub = this.nb_vars - this.outEnv.cardinality();
            for (int i = 0; i < this.nb_vars; ++i) {
                DisposableIntIterator it;
                int nb = 0;
                IntDomainVar var = this.ivars[i];
                if (!this.inKer.get(i) && var.canBeInstantiatedTo(val)) {
                    it = this.s.getDomain().getKernelIterator();
                    while (it.hasNext()) {
                        if (!var.canBeInstantiatedTo(it.next())) continue;
                        ++nb;
                    }
                    it.dispose();
                    if (nb == var.getDomainSize() - 1) {
                        ++lb;
                    }
                }
                if (this.outEnv.get(i)) continue;
                nb = 0;
                it = var.getDomain().getIterator();
                while (it.hasNext()) {
                    int vv = it.next();
                    if (vv == val || !this.s.isInDomainEnveloppe(vv)) continue;
                    ++nb;
                    break;
                }
                it.dispose();
                if (nb != 0) continue;
                --ub;
            }
            this.lb_ub[0][idx] = lb;
            this.min = Math.min(this.min, lb);
            this.lb_ub[1][idx] = ub;
            this.max = Math.max(this.max, ub);
            this.lb_ub[2][idx] = val;
            ++idx;
            e = this.outKinE.nextSetBit(e + 1);
        }
    }

    private void ensureCapacity(int[] arr, int idx) {
        if (idx > arr.length) {
            int[] newArr = arr;
            arr = new int[arr.length * 2 / 3 + 1];
            System.arraycopy(newArr, 0, arr, 0, idx);
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.outKinE.set(x - this.envInf, false);
        this.computeForAllVar();
        this.constAwake(false);
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.outKinE.set(x - this.envInf, false);
        this.computeForAllVar();
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == this.idxS) {
            this.outKinE.clear();
            this.computeForAllVar();
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        if (varIdx < this.nb_vars) {
            this.varToUpdate.set(varIdx, true);
            this.constAwake(false);
        } else {
            this.constAwake(false);
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.isCompletelyInstantiated()) {
            int nb = 0;
            for (IntDomainVar vars : this.ivars) {
                int val = vars.getVal();
                if (!this.s.isInDomainKernel(val)) continue;
                ++nb;
            }
            return nb == this.n.getVal();
        }
        return false;
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer("AMONG(");
        sb.append("[");
        for (int i = 0; i < this.nb_vars; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.ivars[i].pretty());
        }
        sb.append("],").append(this.s.pretty()).append(",");
        sb.append(this.n.pretty()).append(")");
        return sb.toString();
    }
}

