/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.merger;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.variables.integer.IntegerVariable;
import gnu.trove.THashSet;
import java.util.Set;

public final class IntegerVariableMerger {
    public int low;
    public int upp;
    public int[] values;
    public Set<String> optionsSet = new THashSet<String>();

    public IntegerVariableMerger() {
    }

    public IntegerVariableMerger(IntegerVariable v) {
        this();
        this.low = v.getLowB();
        this.upp = v.getUppB();
        this.optionsSet.addAll(v.getOptions());
    }

    public void copy(IntegerVariableMerger d) {
        this.low = d.low;
        this.upp = d.upp;
        if (d.values != null) {
            this.values = new int[d.values.length];
            System.arraycopy(d.values, 0, this.values, 0, this.values.length);
        }
        this.optionsSet = d.optionsSet;
    }

    public IntegerVariable create() {
        if (this.values != null) {
            return new IntegerVariable(StringUtils.randomName(), this.values);
        }
        return new IntegerVariable(StringUtils.randomName(), this.low, this.upp);
    }

    private int[] enumVal() {
        if (this.values != null) {
            if (this.values.length == 2 && this.values[0] == this.values[1]) {
                return new int[]{this.values[0]};
            }
            return this.values;
        }
        int[] val = new int[this.upp - this.low + 1];
        for (int i = 0; i < val.length; ++i) {
            val[i] = this.low + i;
        }
        return val;
    }

    public boolean intersection(IntegerVariable v) {
        if (v.getValues() == null && this.values == null) {
            this.low = Math.max(this.low, v.getLowB());
            this.upp = Math.min(this.upp, v.getUppB());
            if (this.low > this.upp) {
                return false;
            }
        } else {
            int[] val = new int[Math.min(this.upp - this.low + 1, v.getDomainSize())];
            int size = 0;
            int[] ev1 = this.enumVal();
            int[] ev2 = v.enumVal();
            block0: for (int anEv1 : ev1) {
                for (int anEv2 : ev2) {
                    if (anEv1 != anEv2) continue;
                    val[size++] = anEv1;
                    continue block0;
                }
            }
            if (size > 0) {
                this.values = new int[size];
                System.arraycopy(val, 0, this.values, 0, size--);
                this.low = this.values[0];
                this.upp = this.values[size];
            } else {
                return false;
            }
        }
        this.optionsSet = this.mergeOptions(v);
        return true;
    }

    private THashSet<String> mergeOptions(IntegerVariable v) {
        THashSet<String> toptionsSet = new THashSet<String>();
        if (v.getOptions().contains("cp:no_decision") || this.optionsSet.contains("cp:no_decision")) {
            toptionsSet.add("cp:no_decision");
        }
        if (v.getOptions().contains("cp:objective") || this.optionsSet.contains("cp:objective")) {
            toptionsSet.add("cp:objective");
        }
        if (v.getOptions().contains("cp:btree") || this.optionsSet.contains("cp:btree")) {
            toptionsSet.add("cp:btree");
        } else if (v.getOptions().contains("cp:enum") || this.optionsSet.contains("cp:enum")) {
            toptionsSet.add("cp:enum");
        } else if (v.getOptions().contains("cp:blist") || this.optionsSet.contains("cp:blist")) {
            toptionsSet.add("cp:blist");
        } else if (v.getOptions().contains("cp:link") || this.optionsSet.contains("cp:link")) {
            toptionsSet.add("cp:link");
        } else if (v.getOptions().contains("cp:bound") || this.optionsSet.contains("cp:bound")) {
            toptionsSet.add("cp:bound");
        }
        return toptionsSet;
    }
}

