/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.structure.IndexedObject;
import choco.kernel.memory.structure.IntInterval;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.memory.structure.SBitSet;
import choco.kernel.memory.structure.StoredBipartiteSet;
import choco.kernel.memory.structure.StoredIndexedBipartiteSet;
import choco.kernel.memory.structure.StoredIntBipartiteList;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractEnvironment
implements IEnvironment {
    protected int currentWorld = 0;
    private static final int SIZE = 128;
    public IStateIntVector currentBitSet;
    protected int nextOffset;

    @Override
    public final int getWorldIndex() {
        return this.currentWorld;
    }

    @Override
    public final void createSharedBipartiteSet(int size) {
        this.currentBitSet = this.makeBipartiteSet(size);
        this.nextOffset = -1;
    }

    @Override
    public final IStateIntVector getSharedBipartiteSetForBooleanVars() {
        if (this.currentBitSet == null) {
            this.createSharedBipartiteSet(128);
        }
        ++this.nextOffset;
        if (this.nextOffset > this.currentBitSet.size() - 1) {
            this.increaseSizeOfSharedBipartiteSet(this.currentBitSet.size() + 1);
        }
        return this.currentBitSet;
    }

    @Override
    public final int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public <E> StoredBipartiteSet makeStoredBipartiteList(Collection<E> coll) {
        return new StoredBipartiteSet<E>((IEnvironment)this, coll);
    }

    @Override
    public <E> StoredBipartiteSet makeStoredBipartiteList(E[] elm) {
        return new StoredBipartiteSet<E>((IEnvironment)this, elm);
    }

    @Override
    public IStateIntVector makeBipartiteIntList(int[] entries) {
        return new StoredIntBipartiteList(this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int[] entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(int nbEntries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, nbEntries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(IndexedObject[] entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public IStateIntVector makeBipartiteSet(ArrayList<IndexedObject> entries) {
        return new StoredIndexedBipartiteSet((IEnvironment)this, entries);
    }

    @Override
    public <T> PartiallyStoredVector<T> makePartiallyStoredVector() {
        return new PartiallyStoredVector(this);
    }

    @Override
    public PartiallyStoredIntVector makePartiallyStoredIntVector() {
        return new PartiallyStoredIntVector(this);
    }

    @Override
    public IntInterval makeIntInterval(int inf, int sup) {
        return new IntInterval(this, inf, sup);
    }

    @Override
    public IStateBitSet makeBitSet(int size) {
        return new SBitSet(this, size);
    }

    @Override
    public void increaseSizeOfSharedBipartiteSet(int gap) {
        ((StoredIndexedBipartiteSet)this.currentBitSet).increaseSize(gap);
    }
}

