/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.Choco;
import choco.cp.common.util.preprocessor.AbstractAdvancedDetector;
import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.common.util.preprocessor.merger.IntegerVariableMerger;
import choco.cp.model.CPModel;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.kernel.common.util.objects.BooleanSparseMatrix;
import choco.kernel.common.util.objects.ISparseMatrix;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class AbstractIntegerVariableEqualitiesDetector
extends AbstractAdvancedDetector {
    public AbstractIntegerVariableEqualitiesDetector(CPModel model) {
        super(model);
    }

    @Override
    public void apply() {
        ISparseMatrix matrix;
        if (AbstractDetector.LOGGER.isLoggable(Level.CONFIG)) {
            AbstractDetector.LOGGER.config("IntegerVariable equalities detection :");
        }
        if ((matrix = this.analyze()).getNbElement() > 0) {
            this.change(matrix);
        }
    }

    private ISparseMatrix analyze() {
        int nbIntVars = this.model.getNbIntVars();
        BooleanSparseMatrix matrix = new BooleanSparseMatrix(nbIntVars);
        Iterator iteq = this.model.getConstraintByType(ConstraintType.EQ);
        while (iteq.hasNext()) {
            Constraint c = (Constraint)iteq.next();
            Variable v1 = c.getVariables()[0];
            Variable v2 = c.getVariables()[1];
            if (v1.getVariableType() != VariableType.INTEGER || v2.getVariableType() != VariableType.INTEGER) continue;
            matrix.add(v1.getHook(), v2.getHook());
            this.action(c);
        }
        return matrix;
    }

    protected abstract void action(Constraint var1);

    private void change(ISparseMatrix matrix) {
        int nbIntVars = this.model.getNbIntVars();
        matrix.prepare();
        int[] color = new int[nbIntVars];
        Arrays.fill(color, -1);
        TIntObjectHashMap<IntegerVariableMerger> domainByColor = new TIntObjectHashMap<IntegerVariableMerger>();
        int nbDiffObject = this.detect(matrix, nbIntVars, color, domainByColor);
        this.apply(nbDiffObject, nbIntVars, color, domainByColor);
    }

    private int detect(ISparseMatrix matrix, int nbIntVars, int[] color, TIntObjectHashMap<IntegerVariableMerger> domainByColor) {
        int nb = -1;
        IntegerVariableMerger dtmp = new IntegerVariableMerger();
        Iterator<Long> it = matrix.iterator();
        while (it.hasNext()) {
            long v = it.next();
            int i = (int)(v / (long)nbIntVars);
            int j = (int)(v % (long)nbIntVars);
            if (color[i] == -1) {
                color[i] = ++nb;
                domainByColor.put(nb, new IntegerVariableMerger(this.model.getIntVar(i)));
            }
            IntegerVariableMerger d = domainByColor.get(color[i]);
            dtmp.copy(d);
            if (d.intersection(this.model.getIntVar(j))) {
                color[j] = color[i];
                domainByColor.put(color[i], d);
                continue;
            }
            this.add(Choco.eq((IntegerExpressionVariable)this.model.getIntVar(i), (IntegerExpressionVariable)this.model.getIntVar(j)));
            d.copy(dtmp);
            if (color[j] != -1) continue;
            color[j] = ++nb;
            domainByColor.put(nb, new IntegerVariableMerger(this.model.getIntVar(j)));
        }
        return nb;
    }

    protected abstract void apply(int var1, int var2, int[] var3, TIntObjectHashMap<IntegerVariableMerger> var4);

    public static final class IntegerVariableEqualitiesModelDetector
    extends AbstractIntegerVariableEqualitiesDetector {
        public IntegerVariableEqualitiesModelDetector(CPModel model) {
            super(model);
        }

        @Override
        protected void action(Constraint c) {
            this.delete(c);
        }

        @Override
        protected void apply(int k, int nbIntVars, int[] color, TIntObjectHashMap<IntegerVariableMerger> domainByColor) {
            IntegerVariable[] var = new IntegerVariable[k + 1];
            for (int i = 0; i < nbIntVars; ++i) {
                int col = color[i];
                if (col == -1) continue;
                IntegerVariable v = this.model.getIntVar(i);
                if (var[col] == null) {
                    IntegerVariableMerger dtmp = domainByColor.get(col);
                    IntegerVariable vtmp = dtmp.values != null ? new IntegerVariable(StringUtils.randomName(), dtmp.values) : new IntegerVariable(StringUtils.randomName(), dtmp.low, dtmp.upp);
                    vtmp.addOptions(dtmp.optionsSet);
                    var[col] = vtmp;
                    this.add(vtmp);
                }
                this.replaceBy(v, var[col]);
                this.delete(v);
            }
        }
    }

    public static final class IntegerVariableEqualitiesSolverDetector
    extends AbstractIntegerVariableEqualitiesDetector {
        private final PreProcessCPSolver ppsolver;

        public IntegerVariableEqualitiesSolverDetector(CPModel model, PreProcessCPSolver solver) {
            super(model);
            this.ppsolver = solver;
        }

        @Override
        protected void action(Constraint c) {
            this.ppsolver.setCstr(c, null);
        }

        @Override
        protected void apply(int k, int nbIntVars, int[] color, TIntObjectHashMap<IntegerVariableMerger> domainByColor) {
            IntDomainVar[] var = new IntDomainVar[k + 1];
            for (int i = 0; i < nbIntVars; ++i) {
                int col = color[i];
                if (col == -1) continue;
                IntegerVariable v = this.model.getIntVar(i);
                if (var[col] == null) {
                    IntegerVariableMerger dtmp = domainByColor.get(col);
                    IntegerVariable vtmp = dtmp.create();
                    vtmp.addOptions(dtmp.optionsSet);
                    vtmp.findManager(CPModel.properties);
                    var[col] = (IntDomainVar)this.ppsolver.getMod2Sol().readModelVariable(vtmp);
                }
                this.ppsolver.setVar(v, var[col]);
            }
        }
    }
}

