% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_balance_template.R
\name{check_balance_template}
\alias{check_balance_template}
\title{Check balance after template matching.}
\usage{
check_balance_template(dataset, template, template_match_object, cov_list)
}
\arguments{
\item{dataset}{The original dataset.}

\item{template}{A data frame of the template.}

\item{template_match_object}{An object returned by template_match.}

\item{cov_list}{A vector of names of covariates as appeared in the original dataset and the template.}
}
\value{
This function returns a data frame of the overall balance after template
matching. We tabulate the mean and SMD of each covariate in the cov_list in the template,
the matched treated group, and the matched control group.
}
\description{
This function checks the overall balance after template matching and returns a
dataframe with 7 columns: (1) mean of all covariates in the treated group,
(2) mean of all covariates in the control group,
(3) standardized mean differences of (1) and (2),
(4) mean of all covariates in the matched treated group,
(5) mean of all covariates in the matched control group,
(6) standardized mean differences of (4) and (5),
(7) mean of covariates in the template
}
