% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{show,market_model-method}
\alias{show,market_model-method}
\alias{show,market_fit-method}
\title{Prints a short description of the model.}
\usage{
\S4method{show}{market_model}(object)

\S4method{show}{market_fit}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
No return value, called for side effects (print basic model information).
}
\description{
Sends basic information about the model to standard output.
}
\examples{
\donttest{
model <- simulate_model(
  "diseq_stochastic_adjustment", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.1, beta_d0 = 9.8, beta_d = c(0.3, -0.2), eta_d = c(0.6, -0.1),
    # supply coefficients
    alpha_s = 0.1, beta_s0 = 7.1, beta_s = c(0.9), eta_s = c(-0.5, 0.2),
    # price equation coefficients
    gamma = 1.2, beta_p0 = 3.1, beta_p = c(0.8)
  ),
  seed = 31
)

# print short model information
show(model)
}
}
