% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/todo.R
\name{todos}
\alias{todos}
\alias{fixmes}
\title{Get TODOs}
\usage{
todos(
  pattern = NULL,
  path = ".",
  force = getOption("mark.todos.force", FALSE),
  ...
)

fixmes(
  pattern = NULL,
  path = ".",
  force = getOption("mark.todos.force", FALSE),
  ...
)
}
\arguments{
\item{pattern}{A character string containing a regular expression to filter
for comments after tags; default \code{NULL} does not filter}

\item{path}{The file directory to search for the tags}

\item{force}{If \code{TRUE} will force searching for files in directories that do
not contain an \code{.Rproj} file.  This can be controlled with the option
\code{mark.todos.force}}

\item{...}{Additional parameters passed to \code{grep} (Except for \code{pattern}, \code{x},
and \code{value})}
}
\value{
\code{NULL} if none are found, otherwise a \code{data.frame} with the line
number, file name, and TODO comment.
}
\description{
Search for \verb{#`` TODO} tags
}
\details{
Calls \verb{git grep -in "[#] TODO"} to find any lines of a \code{.R} or \code{.Rmd} file
with a comment.
}
