% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largeSpeciesIndicator.R
\name{largeSpeciesIndicator}
\alias{largeSpeciesIndicator}
\title{Calculates the Large Species Indicator}
\usage{
largeSpeciesIndicator(X, group, species.table = NULL, maxlength.table,
  max.length = 85, metric = "BIOMASS", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{group}{character string indicating which species to include in the
indicator calculation. If \code{group = "ALL"}, all species will be
included; otherwise, \code{group} should match a column name in
\code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{maxlength.table}{A dataframe with columns \code{SPECIES} and
\code{MAXLENGTH}, the maximum recorded length of the corresponding species.
Entries in the \code{SPECIES} column should be the unique values of species
codes in \code{X} (or a subset thereof). Other columns in
\code{maxlength.table} are ignored.}

\item{max.length}{The threshold for large species (cm). Default is
\code{max.length = 85} (i.e., large species are those with \code{MAXLENGTH}
>= 85 cm).}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns. \code{ID}, \code{YEAR}, and
 \code{LargeSpeciesIndicator}.

 If there are no observations of large species or no observations in \code{X}
 for spatial scale \eqn{j} in year \eqn{i}, indicator value is assigned
 \code{NA}.
}
\description{
This function calculates the Large Species Indicator (LSI) for
 \eqn{j} areas and \eqn{i} years.
}
\details{
Large Species Indicator (LSI): \deqn{LSI = \Sigma B_i(L_{max} > 85
 cm)/\Sigma B_i} where \eqn{B_i} is biomass of individual species, \eqn{i},
 and \eqn{L_{max}} is the maximum asymptotic length in cm (threshold default
 here is 85 cm; Shin et al., 2010).
}
\examples{
data(X)
data(species.table)
largeSpeciesIndicator(X, group = "ALL", species.table = species.table,
   maxlength.table = species.info, max.length=85,  metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Shephard S, Fung T, Houle JE, Farnsworth KD, Reid DG, Rossberg AG. 2012.
 Size-selective fishing drives species composition in the Celtic Sea. ICES J
 Mar Sci 69:223-234

 Shin, YJ, Shannon LJ, Bundy A, Coll M, Aydin K, Bez N, Blanchard JL, Borges,
 MF, Diallo I, Diaz E, Heymans JJ, Hill L, Johannesen E, Jouffre D, Kifani S,
 Labrosse P, Link JS, Mackinson S, Masski H, Möllmann C, Neira S, Ojaveer H,
 Abdallahi KM, Perry I, Thiao D, Yemane D, and Cury PM. 2010. Using
 indicators for evaluating, comparing and communicating the ecological status
 of exploited marine ecosystems. Part 2: Setting the scene. ICES Journal of
 Marine Science, 67: 692-716
}
\seealso{
Other ecosystem structure and function indicators: \code{\link{allStructure}},
  \code{\link{biomassRatio}},
  \code{\link{communityCondition}},
  \code{\link{largeFishIndicator}},
  \code{\link{meanTLCommunity}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{ecosystem structure and function indicators}
