% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomassPerTL.R
\name{biomassPerTL}
\alias{biomassPerTL}
\title{Calculates the biomass per discrete trophic level}
\usage{
biomassPerTL(X, TL.table, metric = "BIOMASS", TL.grouping = 1, years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{TL.table}{A dataframe with columns \code{SPECIES} and the corresponding
\code{TL} (trophic level). Entries in the \code{SPECIES} column should be
the unique values of species codes in \code{X} (or a subset thereof). Other
columns in \code{TL.table} will be ignored.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{TL.grouping}{Size of the trophic level bin for which to aggregate
biomass. For example, if \code{TL.grouping = 1}, trophic levels are binned
from 1.00 - 1.99, 2.00 - 2.99, etc. If \code{TL.grouping = 0.5}, trophic
levels are binned from 1.00 - 1.49, 1.50 - 1.99, 2.00 - 2.49, 2.50 - 2.99,
etc. Default is \code{TL.grouping = 1}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID}, \code{YEAR}, and the
 corresponding biomass for each trophic level grouping. For example: for
 \code{TL.grouping = 1}, function will return columns \code{BIOMASS_TL2},
 \code{BIOMASS_TL3}, \code{BIOMASS_TL4}. For \code{TL.grouping = 0.5},
 function will return columns \code{BIOMASS_TL2}, \code{BIOMASS_TL2.5},
 \code{BIOMASS_TL3}, \code{BIOMASS_TL3.5}, \code{BIOMASS_TL4},
 \code{BIOMASS_TL4.5}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned \code{NA}.
}
\description{
This function calculates the biomass per discrete trophic level
 for \eqn{j} areas and \eqn{i} years.
}
\examples{
# Compile data
data(X)
data(species.info)

# Calculate indicators
biomassPerTL(X = X, TL.table = species.info, metric = "BIOMASS",
TL.grouping = 1, years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Bundy, A. 2005. Structure and functioning of the eastern Scotian Shelf
 ecosystem before and after the collapse of groundfish stocks in the early
 1990s. Canadian Journal of Fisheries and Aquatic Sciences, 62(7),
 pp.1453-1473.

 Coll M, Shannon LJ, Moloney CL, Palomera I, Tudela S, 2006. Comparing
 trophic flows and fishing impacts of a NW Mediterranean ecosystem with
 coastal upwellings by means of standardized ecological models and
 indicators. Ecol. Model. 198, 53-70.
}
\seealso{
Other stability and resistance indicators: \code{\link{CVBiomass}},
  \code{\link{IVILandings}}, \code{\link{allStability}},
  \code{\link{meanMaxAge}}, \code{\link{meanMaxLength}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{stability and resistance indicators}
