% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mat.polyn.R
\name{pol.order}
\alias{pol.order}
\title{pol.order}
\usage{
pol.order(polyn = NULL, digits = 12)
}
\arguments{
\item{polyn}{the polynomium the order of which is determined.}

\item{digits}{number of significant digits to be considered (values
smaller than 10^(-digits) are taken to be 0 (zero).}
}
\value{
pol.order order of polynomium polyn.
(exclusive the leading unity matrix if present.
pol.order=0 corresponds to the k by k unity matrix)
}
\description{
Function to evaluate (significant)
order of matrix polynomium.
}
\examples{
pol        <- array(1e-8*rnorm(96),dim=c(4,4,6))
pol[,,1:3] <- array(rnorm(48),dim=c(4,4,3))
pol.order(polyn=pol,digits=12)
pol.order(polyn=pol,digits=4)
}

