% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_typical.R
\name{counterfactual}
\alias{counterfactual}
\title{Generate "counterfactual" datasets for use in \code{marginaleffects}'s \code{newdata} argument}
\usage{
counterfactual(..., model = NULL, newdata = NULL)
}
\arguments{
\item{...}{named arguments with vectors of values for the variables to construct (see Examples below.)}

\item{model}{Model object}

\item{newdata}{data.frame (one and only one of the \code{model} and \code{newdata} arguments
must be true).}
}
\value{
A \code{data.frame} where each row of the original data is repeated multiple
times for each of the values of the variables in the \code{at} list. See example
below.
}
\description{
Generate "counterfactual" datasets for use in \code{marginaleffects}'s \code{newdata} argument
}
\details{
If \code{counterfactual} is used in a \code{marginaleffects} or \code{predictions} call as
the \code{newdata} argument, users do not need to specify the \code{model} or \code{newdata}
argument. The data is extracted automatically from the model.

If users supply a model, the data used to fit that model is retrieved using
the \code{insight::get_data} function.

If users supply a model, the data used to fit that model is retrieved using
the \code{insight::get_data} function, and then replicated with different values
of the variables in the \code{at} list.
}
\examples{
# All rows are repeated twice, with different values of `hp`
cd <- counterfactual(newdata = mtcars, hp = c(100, 110))
cd[cd$rowid \%in\% 1:3,]

# We get the same result by feeding a model instead of a data.frame
mod <- lm(mpg ~ hp + wt, mtcars)
cd <- counterfactual(model = mod, hp = c(100, 110))
cd[cd$rowid \%in\% 1:3,]

# Use in `marginaleffects` to compute "Counterfactual Average Marginal Effects"
marginaleffects(mod, newdata = counterfactual(hp = c(100, 110)))
}
