% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_slopes.R
\name{plot_slopes}
\alias{plot_slopes}
\title{Plot Conditional or Marginal Slopes}
\usage{
plot_slopes(
  model,
  variables = NULL,
  condition = NULL,
  by = NULL,
  type = "response",
  vcov = NULL,
  conf_level = 0.95,
  slope = "dydx",
  rug = FALSE,
  gray = FALSE,
  draw = TRUE,
  ...
)
}
\arguments{
\item{model}{Model object}

\item{variables}{Name of the variable whose marginal effect (slope) we want to plot on the y-axis.}

\item{condition}{Conditional slopes
\itemize{
\item Character vector (max length 3): Names of the predictors to display.
\item Named list (max length 3): List names correspond to predictors. List elements can be:
\itemize{
\item Numeric vector
\item Function which returns a numeric vector or a set of unique categorical values
\item Shortcut strings for common reference values: "minmax", "quartile", "threenum"
}
\item 1: x-axis. 2: color/shape. 3: facets.
\item Numeric variables in positions 2 and 3 are summarized by Tukey's five numbers \code{?stats::fivenum}.
}}

\item{by}{Aggregate unit-level estimates (aka, marginalize, average over). Valid inputs:
\itemize{
\item \code{FALSE}: return the original unit-level estimates.
\item \code{TRUE}: aggregate estimates for each term.
\item Character vector of column names in \code{newdata} or in the data frame produced by calling the function without the \code{by} argument.
\item Data frame with a \code{by} column of group labels, and merging columns shared by \code{newdata} or the data frame produced by calling the same function without the \code{by} argument.
\item See examples below.
}}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
default value is used. This default is the first model-related row in
the \code{marginaleffects:::type_dictionary} dataframe.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{slope}{string indicates the type of slope or (semi-)elasticity to compute:
\itemize{
\item "dydx": dY/dX
\item "eyex": dY/dX * Y / X
\item "eydx": dY/dX * Y
\item "dyex": dY/dX / X
}}

\item{rug}{TRUE displays tick marks on the axes to mark the distribution of raw data.}

\item{gray}{FALSE grayscale or color plot}

\item{draw}{\code{TRUE} returns a \code{ggplot2} plot. \code{FALSE} returns a \code{data.frame} of the underlying data.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\value{
A \code{ggplot2} object
}
\description{
Plot slopes on the y-axis against values of one or more predictors (x-axis, colors/shapes, and facets).

The \code{by} argument is used to plot marginal slopes, that is, slopes made on the original data, but averaged by subgroups. This is analogous to using the \code{by} argument in the \code{slopes()} function.

The \code{condition} argument is used to plot conditional slopes, that is, slopes made on a user-specified grid. This is analogous to using the \code{newdata} argument and \code{datagrid()} function in a \code{slopes()} call. Unspecified variables are held at their mean or mode.

See the "Plots" vignette and website for tutorials and information on how to customize plots:
\itemize{
\item https://vincentarelbundock.github.io/marginaleffects/articles/plot.html
\item https://vincentarelbundock.github.io/marginaleffects
}
}
\examples{
library(marginaleffects)
mod <- lm(mpg ~ hp * drat * factor(am), data = mtcars)

plot_slopes(mod, variables = "hp", condition = "drat")

plot_slopes(mod, variables = "hp", condition = c("drat", "am"))

plot_slopes(mod, variables = "hp", condition = list("am", "drat" = 3:5))

plot_slopes(mod, variables = "am", condition = list("hp", "drat" = range))

plot_slopes(mod, variables = "am", condition = list("hp", "drat" = "threenum"))

}
