% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R, R/maraca.R
\docType{package}
\name{maraca}
\alias{maraca}
\alias{maraca-package}
\alias{print.maraca}
\title{maraca package.}
\usage{
maraca(
  data,
  tte_outcomes,
  continuous_outcome,
  arm_levels = c(active = "active", control = "control"),
  column_names = c(outcome = "outcome", arm = "arm", value = "value"),
  fixed_followup_days,
  compute_win_odds = FALSE
)

\method{print}{maraca}(x, ...)
}
\arguments{
\item{data}{A data frame with columns for the following information:
- outcome column, containing the time-to-event and continuous
  labels
- arm column, containing the arm a given row belongs to.
- value column, containing the values.}

\item{tte_outcomes}{A vector of strings containing the time-to-event
outcome labels. The order is kept for the plot.}

\item{continuous_outcome}{A single string containing the continuous
outcome label.}

\item{arm_levels}{A named vector of exactly two strings, mapping the
values used for the active and control arms to the values
used in the data. The names must be "active" and "control"
in this order. Note that this parameter only need to
be specified if you have labels different from
 "active" and "control".}

\item{column_names}{A named vector to map the
outcome, arm, value to the associated column names
in the data. The vector names must match in order "outcome", "arm",
and "value". Note that this parameter only need to be
specified if you have column names different from the ones above.}

\item{fixed_followup_days}{A mandatory specification of the integer number
of fixed follow-up days in the study.}

\item{compute_win_odds}{If TRUE compute the win odds, otherwise (default)
don't compute them.}

\item{x}{an object of class maraca}

\item{...}{further arguments passed to or
from other methods.}
}
\value{
An object of class 'maraca'. The object information must be
        considered private.
}
\description{
Creates the maraca analysis object as an S3 object of
class 'maraca'.
}
\examples{
data(hce_scenario_a)
hce_test <- maraca(
  data = hce_scenario_a,
  tte_outcomes = c("Outcome I", "Outcome II", "Outcome III", "Outcome IV"),
  continuous_outcome = "Continuous outcome",
  fixed_followup_days = 3 * 365,
  column_names = c(outcome = "GROUP", arm = "TRTP", value = "AVAL0"),
  arm_levels = c(active = "Active", control = "Control"),
  compute_win_odds = TRUE
)
}
