% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popupGraph.R
\name{popupGraph}
\alias{popupGraph}
\title{Create HTML strings for popup graphs}
\usage{
popupGraph(graphs, type = c("png", "svg", "html"), ...)
}
\arguments{
\item{graphs}{A \code{list} of figures associated with \code{x}.}

\item{type}{Output filetype, one of "png" (default), "svg" or "html".}

\item{...}{Further arguments passed on to \code{\link{png}} or
\code{\link{svg}}.}
}
\value{
A \code{list} of HTML strings required to create popup graphs.
}
\description{
Create HTML strings for \code{popup} graphs used as input for
\code{\link{mapview}} or \code{\link{leaflet}}.
}
\details{
Type \code{svg} uses native \code{svg} encoding via \code{\link{readLines}}.
\code{height} and \code{width} are set via \code{...} and passed on to
\code{\link{svg}} \cr
Type \code{png} embeds via \code{"<img src = ..."}.
\code{height} and \code{width} are set via \code{...} and passed on to
\code{\link{png}} \cr
Type \code{html} embeds via \code{"<iframe src = ..."}.
\code{height} and \code{width} are set directly in pixels. \cr
}
\examples{
\dontrun{
### example: svg -----

library(sp)

data(meuse)
coordinates(meuse) <- ~ x + y
proj4string(meuse) <- CRS("+init=epsg:28992")

## create plots with points colored according to feature id
library(lattice)
p <- xyplot(copper ~ cadmium, data = meuse@data, col = "grey")
p <- mget(rep("p", length(meuse)))

clr <- rep("grey", length(meuse))
p <- lapply(1:length(p), function(i) {
  clr[i] <- "red"
  update(p[[i]], col = clr)
})

mapview(meuse, popup = popupGraph(p, type = "svg", width = 3, height = 2.5))

### example: png -----
pt <- data.frame(x = 174.764474, y = -36.877245)

coordinates(pt) <- ~ x + y
proj4string(pt) <- "+init=epsg:4326"

p2 <- levelplot(t(volcano), col.regions = terrain.colors(100))

mapview(pt, popup = popupGraph(p2, width = 300, height = 400))

### example: html -----
library(scatterD3)
p <- lapply(1:length(meuse), function(i) {
  clr <-rep(0, length(meuse))
  clr[[i]] <- 1
  scatterD3(x = meuse$cadmium,
            y = meuse$copper,
            col_var = clr,
            legend_width = 0)
})

mapview(meuse, popup = popupGraph(p, type = "html", width = 400, height = 300))

mapview(pt, popup = popupGraph(mapview(pt)@map, type = "html"))
}

}
\seealso{
\code{\link{popupTable}} and \code{\link{popupImage}}.
}

