% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_worldmap.R
\name{mf_worldmap}
\alias{mf_worldmap}
\title{Plot a point on a world map}
\usage{
mf_worldmap(
  x,
  lon,
  lat,
  water_col = "lightblue",
  land_col = "grey60",
  border_col = "grey40",
  border_lwd = 0.8,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}}

\item{lon}{longitude}

\item{lat}{latitude}

\item{water_col}{color of the water}

\item{land_col}{color of the land}

\item{border_col}{color of the borders}

\item{border_lwd}{width of the borders}

\item{...}{further parameters related to the plotted point aspect
(cex, pch, col...)}
}
\value{
No return value, a world map is displayed.
}
\description{
Plot a point on a world map.
}
\note{
The main part of the code is stolen from @fzenoni
(\url{https://gist.github.com/fzenoni/ef23faf6d1ada5e4a91c9ef23b0ba2c1}).
}
\examples{
mtq <- mf_get_mtq()
mf_worldmap(mtq)
mf_worldmap(lon = 24, lat = 39)
mf_worldmap(
  lon = 106, lat = 26,
  pch = 4, lwd = 3, cex = 2, col = "tomato4",
  water_col = "#232525", land_col = "#A9B7C6",
  border_col = "white", border_lwd = 1
)
}
