% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterer_farm.R
\name{global_hierarchical_clusterer}
\alias{global_hierarchical_clusterer}
\title{Create a dude to perform hierarchical clustering in a global context using the \link{hclust} package.}
\usage{
global_hierarchical_clusterer(method, dists)
}
\arguments{
\item{method}{A string to pass to \link{hclust} to tell it what kind of clustering to do.}

\item{dists}{The global distance matrix on which to run clustering to determine a global cutting height.}
}
\value{
A function that inputs a list of distance matrices and returns a list containing one vector per matrix, whose element names are data point names and whose values are cluster labels (relative to each matrix).
}
\description{
Create a dude to perform hierarchical clustering in a global context using the \link{hclust} package.
}
\details{
This clusterer determines cutting heights for dendrograms by cutting them all according to the best cutting height when the data is clustered together. "Best" here means cutting the dendrogram just above the merge point with the longest unbroken gap until the next merge points.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

dists = dist(data)

num_bins = 10
percent_overlap = 25

cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

create_1D_mapper_object(data, dists, projx, cover, global_hierarchical_clusterer("mcquitty", dists))
}
