% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{dphase}
\alias{dphase}
\title{Probability density function of PH distribution}
\usage{
dphase(x, ph, log = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector of quantiles.}

\item{ph}{An instance of PH distribution.}

\item{log}{logical; if TRUE, densities y are returned as log(y)}

\item{...}{Others.}
}
\value{
A vector of densities.
}
\description{
Compute the probability density function (p.d.f.) for a given PH distribution
}
\examples{
## create a PH with specific parameters
(phdist <- ph(alpha=c(1,0,0),
              Q=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)),
              xi=c(2,2,0)))

## p.d.f. for 0, 0.1, ..., 1
dphase(x=seq(0, 1, 0.1), ph=phdist)

}
