% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{selectMap}
\alias{selectMap}
\alias{selectMap}
\alias{selectMap.leaflet}
\title{Interactively Select Map Features}
\usage{
selectMap(x, ...)

\method{selectMap}{leaflet}(x = NULL, styleFalse = list(fillOpacity = 0.2,
  weight = 1, opacity = 0.4), styleTrue = list(fillOpacity = 0.7, weight = 3,
  opacity = 0.7), ns = "mapedit-select", viewer = shiny::paneViewer(), ...)
}
\arguments{
\item{x}{\code{leaflet} or \code{mapview} map to use for selection}

\item{...}{other arguments}

\item{styleFalse, styleTrue}{names \code{list} of CSS styles used
for selected (\code{styleTrue}) and deselected (\code{styleFalse})}

\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer. See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}
}
\description{
Interactively Select Map Features
}
\details{
When setting \code{viewer = browserViewer(browser = getOption("browser"))} and
  the systems default browser is Firefox, the browser window will likely not
  automatically close when the app is closed (by pressing "done" or "cancel").
  To enable automatic closing of tabs/windows in Firefox try the following:
  \itemize{
    \item{input "about:config " to your firefox address bar and hit enter}
    \item{make sure your "dom.allow_scripts_to_close_windows" is true}
  }
}
\examples{
\dontrun{
library(mapedit)
library(mapview)

lf <- mapview()

# draw some polygons that we will select later
drawing <- lf \%>\%
  editMap()

# little easier now with sf
mapview(drawing$finished)

# especially easy with selectFeatures
selectFeatures(drawing$finished)


# use @bhaskarvk USA Albers with leaflet code
#  https://bhaskarvk.github.io/leaflet/examples/proj4Leaflet.html
#devtools::install_github("hrbrmstr/albersusa")
library(albersusa)
library(sf)
library(leaflet)
library(mapedit)

spdf <- usa_sf()
pal <- colorNumeric(
  palette = "Blues",
  domain = spdf$pop_2014
)

bounds <- c(-125, 24 ,-75, 45)

(lf <- leaflet(
  options=
    leafletOptions(
      worldCopyJump = FALSE,
      crs=leafletCRS(
        crsClass="L.Proj.CRS",
        code='EPSG:2163',
        proj4def=paste0(
          '+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 ',
          '+b=6370997 +units=m +no_defs'
        ),
        resolutions = c(65536, 32768, 16384, 8192, 4096, 2048,1024, 512, 256, 128)
      )
    )
  ) \%>\%
  fitBounds(bounds[1], bounds[2], bounds[3], bounds[4]) \%>\%
  setMaxBounds(bounds[1], bounds[2], bounds[3], bounds[4]) \%>\%
  mapview::addFeatures(
    data=spdf, weight = 1, color = "#000000",
    # adding group necessary for identification
    layerId = ~iso_3166_2,
    fillColor=~pal(pop_2014),
    fillOpacity=0.7,
    label=~stringr::str_c(name,' ', format(pop_2014, big.mark=",")),
    labelOptions= labelOptions(direction = 'auto')
  )
)


# test out selectMap with albers example
selectMap(
  lf,
  styleFalse = list(weight = 1),
  styleTrue = list(weight = 4)
)
}
}
