% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayests.R
\name{hist.mapbayests}
\alias{hist.mapbayests}
\title{Plot posterior distribution of bayesian estimates}
\usage{
\method{hist}{mapbayests}(x, select_eta = x$arg.optim$select_eta, ...)
}
\arguments{
\item{x}{A \code{mapbayests} object.}

\item{select_eta}{a vector of numeric values, the numbers of the ETAs to show (default are estimated ETAs).}

\item{...}{additional arguments (not used)}
}
\value{
a \code{ggplot} object.
}
\description{
Plot posterior distribution of bayesian estimates
}
\details{
Use this function to plot the results of the estimations, in the form of histograms with the \emph{a priori} distribution in the background. For every parameter, the inter-individual variability is displayed, as well as the percentile of the patient in the corresponding distribution (if n = 1 patient).
For additional modifications, you can add extra \verb{+function(...)} in order to modify the plot as a regular \code{ggplot2} object.
}
\examples{
\donttest{
est <- mapbayest(exmodel(ID = 1))

# Default Method
h <- hist(est)

# Can be modified with `ggplot2`
h +
  ggplot2::labs(title = "Awesome estimations")

# Select the ETAs
hist(est, select_eta = c(1,3))
}
}
