% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgmod.R
\name{data_helpers}
\alias{data_helpers}
\alias{adm_lines}
\alias{obs_lines}
\alias{add_covariates}
\alias{see_data}
\title{Data helpers}
\usage{
adm_lines(x, ...)

obs_lines(x, time, DV, mdv = 0, cmt = NULL, DVmet = NULL, ...)

add_covariates(x, covariates, ...)

see_data(x, ...)
}
\arguments{
\item{x}{model object}

\item{...}{passed to \code{mrgsolve::ev()} in \code{adm_lines()}}

\item{time, DV, mdv, cmt, DVmet}{passed to \code{obs_lines()}}

\item{covariates}{a list of named covariates, with a single value or same number of lines than data}
}
\value{
a \code{mrgmod} object, with a dataset in the \verb{@args$data} slot.
}
\description{
Helpers to build data set.
}
\details{
Helpful functions build the data set. Instead of painfully build a data set and mind how to format the data, you can pass information about :
\itemize{
\item administrations with \code{adm_lines()},
\item observations with \code{obs_lines()}
\item covariates with \code{add_covariates()}.
}

These functions are passed to a \code{mrgmod} object (mrgsolve model), and return a \code{mrgmod} object with a data set inside with the correct formatting (so-called NM-TRAN format), so that mrgsolve or mapbayr functions can be passed along within a pipe-friendly workflow.

These functions are meant to be used for one single patient at a time. Multiple ID is accepted, but the user is asked to check if the output is acceptable.
}
\examples{
library(magrittr)
# First, code a model
code1 <- "$PARAM ETA1 = 0, ETA2 = 0,
KA = 0.5, TVCL = 1.1, TVV = 23.3
$OMEGA 0.41 0.32
$SIGMA 0.04 0
$CMT DEPOT CENT
$PK
double CL=TVCL*exp(ETA1+ETA(1));
double V=TVV*exp(ETA2+ETA(2)) ;
$ERROR
double DV=CENT/V*(1+EPS(1))+EPS(2);
$PKMODEL ncmt = 1, depot = TRUE
$CAPTURE DV CL"
my_model <- mrgsolve::mcode("my_model", code1)

my_model \%>\%
  adm_lines(amt = 500, cmt = 1) \%>\%
  obs_lines(time = c(1.1, 5.2), DV = c(15.1, 29.5), cmt = 2) \%>\%
  # get_data() # for curiosity, you can extract the data set at this step
  mapbayest()

# If `[ADM]` or `[OBS]` are set in `$CMT` in model code, the `cmt =` argument are superfluous.

}
