% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest.R
\name{mapbayest}
\alias{mapbayest}
\alias{mbrest}
\title{Estimate parameters (maximum a posteriori)}
\usage{
mapbayest(
  x,
  data = NULL,
  method = "L-BFGS-B",
  force_initial_eta = NULL,
  quantile_bound = 0.001,
  control = list(),
  check = TRUE,
  verbose = TRUE,
  reset = TRUE,
  output = NULL
)

mbrest(...)
}
\arguments{
\item{x}{the model object}

\item{data}{NMTRAN-like data set}

\item{method}{optimization method; possible values are \code{L-BFGS-B} (the default) and \code{newuoa}}

\item{force_initial_eta}{a vector of numeric values to start the estimation from (default to 0 for "L-BFGS-B")}

\item{quantile_bound}{a numeric value representing the quantile of the normal distribution admitted to define the bounds for L-BFGS-B (default is 0.001, i.e. 0.1\%)}

\item{control}{a list passed to the optimizer (see \code{\link{optimx}} documentation)}

\item{check}{check model code for mapbayr specification (a logical, default is \code{TRUE})}

\item{verbose}{print the steps of the estimations to the console (a logical, default is \code{TRUE})}

\item{reset}{reset to different initial eta values if L-BFGS-B converges at initial values (a logical, default is \code{TRUE})}

\item{output}{if \code{NULL} (the default) a mapbayests object is returned; if \code{df} a \emph{mapbay_tab} dataframe is returned}

\item{...}{passed to mapbayest}
}
\value{
a mapbayests model object
}
\description{
The main function of the mapbayr package. Performs a \emph{maximum a posteriori} Bayesian estimation of parameters, from a mrgsolve model object and a dataset containing information about administrations and observed concentrations.
}
