% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_codelist}
\alias{esp_codelist}
\title{Spanish Code Translation Data Frame}
\format{
A data frame with 59 rows
codes as columns
\itemize{
\item \strong{nuts+.code}: NUTS code of each subdivision.
\item \strong{nuts+.code}: NUTS name of each subdivision.
\item \strong{codauto}: INE code of each autonomous community.
\item \strong{iso2.+.code}: ISO2 code of each autonomous
community and province.
\item \strong{ine.+.name}: INE name of each autonomous community
and province.
\item \strong{iso2.+.name.(lang)}: ISO2 name of each autonomous community
and province. Several languages available.
\item \strong{cldr.+.name.(lang)}: CLDR name of each autonomous community and
province. Several languages available.
\item \strong{ccaa.short.+}: Short (common) name of each autonomous
community. Several languages available.
\item \strong{cpro}: INE code of each province.
\item \strong{prov.shortname.+}: Short (common) name of each province.
Several languages available.
}
}
\source{
\itemize{
\item \strong{INE}: Instituto Nacional de Estadistica: \url{https://www.ine.es/}
\item \strong{Eurostat (NUTS)}: \url{https://ec.europa.eu/eurostat/web/nuts/background}
\item \strong{ISO}: \url{https://www.iso.org/home.html}
\item \strong{CLDR}: \url{https://unicode-org.github.io/cldr-staging/charts/38/index.html}
}
}
\description{
A data frame used internally for translating codes and names of the
different subdivisions of Spain. The data frame provides the hierarchy of
the subdivisions including NUTS1 level, Autonomous Communities
(equivalent to NUTS2), Provinces and NUTS3 level. See Note.
}
\note{
Languages available are:
\itemize{
\item \strong{"en"}: English
\item \strong{"es"}: Spanish
\item \strong{"ca"}: Catalan
\item \strong{"ga"}: Galician
\item \strong{"eu"}: Basque
}

Although NUTS2 matches the first subdivision level of Spain
(CCAA - Autonomous Communities), it should be noted that NUTS3 does not
match the second subdivision level of Spain (Provinces). NUTS3 provides a
dedicated code for major islands whereas the Provinces doesn't.

Ceuta and Melilla has an specific status (Autonomous Cities) but are
considered as communities with a single province (as Madrid, Asturias
or Murcia) on this dataset.
}
\examples{

data("esp_codelist")
}
\seealso{
Other datasets: 
\code{\link{esp_munic.sf}},
\code{\link{esp_nuts.sf}},
\code{\link{leaflet.providersESP.df}},
\code{\link{pobmun19}}

Other political: 
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_simpl_prov}()}

Other dictionary: 
\code{\link{esp_dict_region_code}()}
}
\concept{datasets}
\concept{dictionary}
\concept{political}
