% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformat.R
\name{reformat}
\alias{reformat}
\alias{to_uniplex}
\alias{to_undirected}
\alias{to_directed}
\alias{to_redirected}
\alias{to_reciprocated}
\alias{to_acyclic}
\alias{to_unweighted}
\alias{to_unsigned}
\alias{to_unnamed}
\alias{to_named}
\alias{to_simplex}
\alias{to_anti}
\title{Modifying network formats}
\usage{
to_uniplex(.data, tie)

to_undirected(.data)

to_directed(.data)

to_redirected(.data)

to_reciprocated(.data)

to_acyclic(.data)

to_unweighted(.data, threshold = 1)

to_unsigned(.data, keep = c("positive", "negative"))

to_unnamed(.data)

to_named(.data, names = NULL)

to_simplex(.data)

to_anti(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{tie}{Character string naming a tie attribute to retain from a graph.}

\item{threshold}{For a matrix, the threshold to binarise/dichotomise at.}

\item{keep}{In the case of a signed network, whether to retain
the "positive" or "negative" ties.}

\item{names}{Character vector of the node names. NULL by default.}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions reformat manynet-consistent data.
\itemize{
\item \code{to_uniplex()} reformats multiplex network data to a single type of tie.
\item \code{to_undirected()} reformats directed network data to an undirected network.
\item \code{to_directed()} reformats undirected network data to a directed network.
\item \code{to_redirected()} reformats the direction of directed network data, flipping any existing direction.
\item \code{to_reciprocated()} reformats directed network data such that every directed tie is reciprocated.
\item \code{to_acyclic()} reformats network data to an acyclic graph.
\item \code{to_unweighted()} reformats weighted network data to unweighted network data.
\item \code{to_unsigned()} reformats signed network data to unsigned network data.
\item \code{to_unnamed()} reformats labelled network data to unlabelled network data.
\item \code{to_named()} reformats unlabelled network data to labelled network data.
\item \code{to_simplex()} reformats complex network data, containing loops, to simplex network data, without any loops.
\item \code{to_anti()} reformats network data into its complement, where only ties \emph{not} present in the original network
are included in the new network.
}

If the format condition is not met,
for example \code{to_undirected()} is used on a network that is already undirected,
the network data is returned unaltered.
No warning is given so that these functions can be used to ensure conformance.

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_acyclic \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_directed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_named \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_reciprocated \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_redirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_simplex \tab 0 \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_undirected \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_uniplex \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unnamed \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unsigned \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_unweighted \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
}
}
\section{Functions}{
\itemize{
\item \code{to_undirected()}: Returns an object that has any edge direction removed,
so that any pair of nodes with at least one directed edge will be
connected by an undirected edge in the new network.
This is equivalent to the "collapse" mode in \code{{igraph}}.

\item \code{to_redirected()}: Returns an object that has any edge direction transposed,
or flipped, so that senders become receivers and receivers become senders.
This essentially has no effect on undirected networks or reciprocated ties.

\item \code{to_reciprocated()}: Returns an object where all ties are reciprocated.

\item \code{to_unweighted()}: Returns an object that has all edge weights removed.

\item \code{to_unsigned()}: Returns a network with either just the "positive" ties
or just the "negative" ties

\item \code{to_unnamed()}: Returns an object with all vertex names removed

\item \code{to_named()}: Returns an object that has random vertex names added

\item \code{to_simplex()}: Returns an object that has all loops or self-ties removed

}}
\examples{
as_tidygraph(create_filled(5)) \%>\%
  mutate_ties(type = sample(c("friend", "enemy"), 10, replace = TRUE)) \%>\%
  to_uniplex("friend")
to_anti(ison_southern_women)
#graphr(to_anti(ison_southern_women))
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{from}},
\code{\link{manip_correlation}},
\code{\link{manip_permutation}},
\code{\link{manip_split}},
\code{\link{miss}},
\code{\link{to_levels}},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
