% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_generate.R, R/manip_correlation.R
\name{make_generate}
\alias{make_generate}
\alias{generate_random}
\alias{generate_configuration}
\alias{generate_smallworld}
\alias{generate_scalefree}
\alias{generate_utilities}
\alias{generate_fire}
\alias{generate_islands}
\alias{generate_citations}
\alias{generate_permutation}
\title{Making networks with a stochastic element}
\usage{
generate_random(n, p = 0.5, directed = FALSE, with_attr = TRUE)

generate_configuration(.data)

generate_smallworld(n, p = 0.05, directed = FALSE, width = 2)

generate_scalefree(n, p = 1, directed = FALSE)

generate_utilities(n, steps = 1, volatility = 0, threshold = 0)

generate_fire(n, contacts = 1, their_out = 0, their_in = 1, directed = FALSE)

generate_islands(n, islands = 2, p = 0.5, bridges = 1, directed = FALSE)

generate_citations(
  n,
  ties = sample(1:4, 1),
  agebins = max(1, n/10),
  directed = FALSE
)

generate_permutation(.data, with_attr = TRUE)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Power of the preferential attachment, default is 1.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{with_attr}{Logical whether any attributes of the object
should be retained.
By default TRUE.}

\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{width}{Integer specifying the width of the ring,
breadth of the branches, or maximum extent of the neighbourbood.}

\item{steps}{Number of simulation steps to run.
By default 1: a single, one-shot simulation.
If more than 1, further iterations will update the utilities
depending on the values of the volatility and threshold parameters.}

\item{volatility}{How much change there is between steps.
Only if volatility is more than 1 do further simulation steps make sense.
This is passed on to \code{stats::rnorm} as the \code{sd} or standard deviation
parameter.}

\item{threshold}{This parameter can be used to mute or disregard stepwise
changes in utility that are minor.
The default 0 will recognise all changes in utility,
but raising the threshold will mute any changes less than this threshold.}

\item{contacts}{Number of contacts or ambassadors chosen from among existing
nodes in the network.
By default 1.
See \code{igraph::sample_forestfire()}.}

\item{their_out}{Probability of tieing to a contact's outgoing ties.
By default 0.}

\item{their_in}{Probability of tieing to a contact's incoming ties.
By default 1.}

\item{islands}{Number of islands or communities to create.
By default 2.
See \code{igraph::sample_islands()} for more.}

\item{bridges}{Number of bridges between islands/communities.
By default 1.}

\item{ties}{Number of ties to add per new node.
By default a uniform random sample from 1 to 4 new ties.}

\item{agebins}{Number of aging bins.
By default either \eqn{\frac{n}{10}} or 1,
whichever is the larger.
See \code{igraphr::sample_last_cit()} for more.}
}
\value{
By default a \code{tbl_graph} object is returned,
but this can be coerced into other types of objects
using \code{as_edgelist()}, \code{as_matrix()},
\code{as_tidygraph()}, or \code{as_network()}.

By default, all networks are created as undirected.
This can be overruled with the argument \code{directed = TRUE}.
This will return a directed network in which the arcs are
out-facing or equivalent.
This direction can be swapped using \code{to_redirected()}.
In two-mode networks, the directed argument is ignored.
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some element of randomisation.
They are particularly useful for creating a distribution of networks
for exploring or testing network properties.
\itemize{
\item \code{generate_random()} generates a random network with ties appearing at some probability.
\item \code{generate_configuration()} generates a random network consistent with a
given degree distribution.
\item \code{generate_smallworld()} generates a small-world structure via ring rewiring at some probability.
\item \code{generate_scalefree()} generates a scale-free structure via preferential attachment at some probability.
\item \code{generate_utilities()} generates a random utility matrix.
\item \code{generate_fire()} generates a forest fire model.
\item \code{generate_islands()} generates an islands model.
\item \code{generate_citations()} generates a citations model.
}

These functions can create either one-mode or two-mode networks.
To create a one-mode network, pass the main argument \code{n} a single integer,
indicating the number of nodes in the network.
To create a two-mode network, pass \code{n} a vector of \emph{two} integers,
where the first integer indicates the number of nodes in the first mode,
and the second integer indicates the number of nodes in the second mode.
As an alternative, an existing network can be provided to \code{n}
and the number of modes, nodes, and directedness will be inferred.
}
\examples{
graphr(generate_random(12, 0.4))
# graphr(generate_random(c(6, 6), 0.4))
graphr(generate_smallworld(12, 0.025))
graphr(generate_smallworld(12, 0.25))
graphr(generate_scalefree(12, 0.25))
graphr(generate_scalefree(12, 1.25))
generate_fire(10)
generate_islands(10)
generate_citations(10)
}
\references{
Erdos, Paul, and Alfred Renyi. (1959).
"\href{https://www.renyi.hu/~p_erdos/1959-11.pdf}{On Random Graphs I}"
\emph{Publicationes Mathematicae}. 6: 290–297.

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.

Barabasi, Albert-Laszlo, and Reka Albert. 1999.
“Emergence of Scaling in Random Networks.”
\emph{Science} 286(5439):509–12.
\doi{10.1126/science.286.5439.509}.
}
\seealso{
Other makes: 
\code{\link{learning}},
\code{\link{make_create}},
\code{\link{make_explicit}},
\code{\link{play}},
\code{\link{read}},
\code{\link{write}()}
}
\concept{makes}
