% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_path.R
\name{check_path}
\alias{check_path}
\title{Check a Path Exists in a Model}
\usage{
check_path(x, y, m = NULL, fit = NULL, est = NULL)
}
\arguments{
\item{x}{Character. The name of
predictor at the start of the path.}

\item{y}{Character. The name of the
outcome variable at the end of the
path.}

\item{m}{A vector of the variable
names of the mediators. The path goes
from the first mediator successively
to the last mediator. If \code{NULL}, the
default, the path goes from \code{x} to
\code{y}.}

\item{fit}{The fit object. Currently
only supports a
\code{lavaan::lavaan-class} object or a
list of outputs of \code{\link[=lm]{lm()}}.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[semTools:runMI]{semTools::runMI()}} or
its wrapper, such as \code{\link[semTools:runMI]{semTools::sem.mi()}}.}

\item{est}{The output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. If
\code{NULL}, the default, it will be
generated from \code{fit}. If supplied,
\code{fit} will ge ignored.}
}
\value{
A logical vector of length
one. \code{TRUE} if the path is valid,
\code{FALSE} if the path is invalid.
}
\description{
It checks whether a
path, usually an indirect path,
exists in a model.
}
\details{
It checks whether the path
defined by a predictor (\code{x}), an
outcome (\code{y}), and optionally a
sequence of mediators (\code{m}), exists
in a model. It can check models in a
\code{lavaan::lavaan-class} object or a
list of outputs of \code{\link[=lm]{lm()}}.
It also support
\code{lavaan.mi} objects
returned by
\code{\link[semTools:runMI]{semTools::runMI()}} or
its wrapper, such as \code{\link[semTools:runMI]{semTools::sem.mi()}}.

For example, in the following model
in \code{lavaan} syntax

\if{html}{\out{<div class="sourceCode">}}\preformatted{m1 ~ x
m2 ~ m1
m3 ~ x
y ~ m2 + m3
}\if{html}{\out{</div>}}

This path is valid: \verb{x = "x", y = "y", m = c("m1", "m2")}

This path is invalid: \verb{x = "x", y = "y", m = c("m2")}

This path is also invalid: \verb{x = "x", y = "y", m = c("m1", "m2")}
}
\examples{

library(lavaan)
data(data_serial_parallel)
dat <- data_serial_parallel
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE)

# The following paths are valid
check_path(x = "x", y = "y", m = c("m11", "m12"), fit = fit)
check_path(x = "x", y = "y", m = "m2", fit = fit)
# The following paths are invalid
check_path(x = "x", y = "y", m = c("m11", "m2"), fit = fit)
check_path(x = "x", y = "y", m = c("m12", "m11"), fit = fit)

}
