% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{multicompplot}
\alias{multicompplot}
\title{Multi components plot}
\usage{
multicompplot(
  object,
  x,
  comps = NULL,
  row4comp = 6,
  col4comp = 1,
  pseq4comp = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class "\code{multirec}." Usually, a result of a call to \code{multirec}}

\item{x}{template image}

\item{comps}{a component sequence to be plotted.}

\item{row4comp}{the number of rows per a component}

\item{col4comp}{the number of columns per a component}

\item{pseq4comp}{the number of images per a component}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This is a function that plots the vectorized image returned to its original dimensions by the multirec function.
}
\details{
\code{multicompplot} requires the output result of \code{msma} function.
}
\examples{
\donttest{
data(baseimg)
data(diffimg)
data(mask)
data(template)
img1 = simbrain(baseimg = baseimg, diffimg = diffimg, mask=mask)
B1 = rbfunc(imagedim=img1$imagedim, seppix=2, hispec=FALSE, mask=img1$brainpos)
SB1 = basisprod(img1$S, B1)
fit111 = msma(SB1, comp=2)
ws = multirec(fit111, imagedim=img1$imagedim, B=B1, mask=img1$brainpos)
multicompplot(ws, template)
}
}
