/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountMatchesMatching
extends Pipe {
    private static Logger logger = MalletLogger.getLogger(CountMatchesMatching.class.getName());
    String feature;
    Pattern regex;
    Pattern moreSpecificRegex;
    boolean normalizeByRegexMatches = false;

    public CountMatchesMatching(String featureName, Pattern regex, Pattern moreSpecificRegex, boolean normalizeByRegexMatches) {
        this.feature = featureName;
        this.regex = regex;
        this.moreSpecificRegex = regex;
        this.normalizeByRegexMatches = normalizeByRegexMatches;
    }

    public CountMatchesMatching(String featureName, Pattern regex, Pattern moreSpecificRegex) {
        this(featureName, regex, moreSpecificRegex, false);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            int count = 0;
            int moreSpecificCount = 0;
            Token t = (Token)ts.get(i);
            Matcher matcher = this.regex.matcher(t.getText());
            while (matcher.find()) {
                ++count;
                logger.info("CountMatchesMatching found >" + matcher.group() + "<");
                Matcher moreSpecificMatcher = this.moreSpecificRegex.matcher(t.getText().substring(matcher.start()));
                if (!moreSpecificMatcher.lookingAt()) continue;
                ++moreSpecificCount;
                logger.info("CountMatchesMatching sound >" + moreSpecificMatcher.group() + "<");
            }
            if (moreSpecificCount <= 0) continue;
            t.setFeatureValue(this.feature, this.normalizeByRegexMatches ? (double)moreSpecificCount / (double)count : (double)moreSpecificCount);
        }
        return carrier;
    }
}

