/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class ForceDirectedLayout
implements GraphLayoutManager,
Runnable {
    private VisualGraph vGraph;
    private double springLength = 30.0;
    private double stiffness = 30.0;
    private double electricalRepulsion = 200.0;
    private double increment = 0.5;
    private boolean initialized = false;
    private Thread runner;
    private ArrayList fixedVertexList;

    public ForceDirectedLayout(VisualGraph vGraph) {
        this.vGraph = vGraph;
        this.fixedVertexList = new ArrayList(10);
    }

    public double getSpringLength() {
        return this.springLength;
    }

    public double getStiffness() {
        return this.stiffness;
    }

    public double getEletricalRepulsion() {
        return this.electricalRepulsion;
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setSpringLength(double length) {
        this.springLength = length;
    }

    public void setStiffness(double stiffness) {
        this.stiffness = stiffness;
    }

    public void setEletricalRepulsion(double repulsion) {
        this.electricalRepulsion = repulsion;
    }

    public void setIncrement(double increment) {
        this.increment = increment;
    }

    public void addFixedVertex(VisualVertex vVertex) {
        this.fixedVertexList.add(vVertex);
    }

    public boolean isVertexFixed(VisualVertex vVertex) {
        return this.fixedVertexList.contains(vVertex);
    }

    public void removeFixedVertex(VisualVertex vVertex) {
        this.fixedVertexList.remove(vVertex);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void paintEdge(Graphics2D g2d, VisualEdge vEdge) {
        this.routeEdge(g2d, vEdge);
    }

    public void routeEdge(Graphics2D g2d, VisualEdge vEdge) {
        GeneralPath gPath = vEdge.getGeneralPath();
        g2d.setColor(vEdge.getOutlinecolor());
        Point2D.Float fromcenter = new Point2D.Float(new Double(vEdge.getVisualVertexA().getBounds2D().getCenterX()).floatValue(), new Double(vEdge.getVisualVertexA().getBounds2D().getCenterY()).floatValue());
        Point2D.Float tocenter = new Point2D.Float(new Double(vEdge.getVisualVertexB().getBounds2D().getCenterX()).floatValue(), new Double(vEdge.getVisualVertexB().getBounds2D().getCenterY()).floatValue());
        gPath.reset();
        gPath.moveTo(fromcenter.x, fromcenter.y);
        gPath.lineTo(tocenter.x, tocenter.y);
    }

    public void layout() {
        this.initialized = true;
        if (this.runner != null) {
            this.runner = null;
        } else {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    private void relax(VisualVertex vVertex) {
        double distance;
        double adjY;
        double adjX;
        int i;
        if (this.fixedVertexList.contains(vVertex)) {
            return;
        }
        double xForce = 0.0;
        double yForce = 0.0;
        double xSpring = 0.0;
        double ySpring = 0.0;
        double xRepulsion = 0.0;
        double yRepulsion = 0.0;
        double adjacentDistance = 0.0;
        double thisX = vVertex.getBounds2D().getCenterX();
        double thisY = vVertex.getBounds2D().getCenterY();
        List adjacentVertices = this.vGraph.getGraph().getAdjacentVertices(vVertex.getVertex());
        int size = adjacentVertices.size();
        for (i = 0; i < size; ++i) {
            VisualVertex adjacentVisualVertex = this.vGraph.getVisualVertex((Vertex)adjacentVertices.get(i));
            if (adjacentVisualVertex == vVertex) continue;
            adjX = adjacentVisualVertex.getBounds2D().getCenterX();
            distance = Point2D.distance(adjX, adjY = adjacentVisualVertex.getBounds2D().getCenterY(), thisX, thisY);
            if (distance == 0.0) {
                distance = 1.0E-4;
            }
            double spring = this.stiffness * Math.log(distance / this.springLength) * ((thisX - adjX) / distance);
            xSpring += spring;
            spring = this.stiffness * Math.log(distance / this.springLength) * ((thisY - adjY) / distance);
            ySpring += spring;
        }
        List allVertices = this.vGraph.getVisualVertices();
        size = allVertices.size();
        for (i = 0; i < size; ++i) {
            VisualVertex aVisualVertex = (VisualVertex)allVertices.get(i);
            if (aVisualVertex == vVertex) continue;
            adjX = aVisualVertex.getBounds2D().getCenterX();
            distance = Point2D.distance(adjX, adjY = aVisualVertex.getBounds2D().getCenterY(), thisX, thisY);
            if (distance == 0.0) {
                distance = 1.0E-4;
            }
            double repulsion = this.electricalRepulsion / distance * ((thisX - adjX) / distance);
            xRepulsion += repulsion;
            repulsion = this.electricalRepulsion / distance * ((thisY - adjY) / distance);
            yRepulsion += repulsion;
        }
        xForce = xSpring - xRepulsion;
        yForce = ySpring - yRepulsion;
        double xadj = 0.0 - xForce * this.increment;
        double yadj = 0.0 - yForce * this.increment;
        double newX = vVertex.getBounds2D().getMinX() + xadj;
        double newY = vVertex.getBounds2D().getMinY() + yadj;
        if (newX >= 0.0 && newY >= 0.0) {
            vVertex.setLocationDelta(xadj, yadj);
        } else if (newX < 0.0 && newY >= 0.0) {
            xadj = vVertex.getBounds2D().getMinX() > 0.0 ? 0.0 - vVertex.getBounds2D().getMinX() : 0.0;
            vVertex.setLocationDelta(xadj, yadj);
        } else if (newY < 0.0 && newX >= 0.0) {
            yadj = vVertex.getBounds2D().getMinY() > 0.0 ? 0.0 - vVertex.getBounds2D().getMinY() : 0.0;
            vVertex.setLocationDelta(xadj, yadj);
        }
    }

    public void drawLayout() {
        this.vGraph.repaint();
    }

    public void addVertex(VisualVertex vVertex) {
    }

    public void removeEdge(VisualEdge vEdge) {
    }

    public void removeVertex(VisualVertex vVertex) {
    }

    public void addEdge(VisualEdge vEdge) {
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.runner) {
            List visualVertices = this.vGraph.getVisualVertices();
            int size = visualVertices.size();
            for (int i = 0; i < size; ++i) {
                VisualVertex vVertex = (VisualVertex)visualVertices.get(i);
                this.relax(vVertex);
            }
            this.vGraph.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }
}

