% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magpie_expand_dim.R
\name{magpie_expand_dim}
\alias{magpie_expand_dim}
\title{magpie_expand_dim}
\usage{
magpie_expand_dim(x, ref, dim = 1)
}
\arguments{
\item{x}{MAgPIE object that should be expanded}

\item{ref}{MAgPIE object that serves as a reference}

\item{dim}{dimension that should be expanded}
}
\value{
An expanded version of x.
}
\description{
Expands a single MAgPIE object dimension
}
\details{
Expansion means here that the dimensions of x are expanded acordingly to
ref. Please note that this is really only about expansion. In the case that
one dimension of ref is smaller than of x nothing happens with this
dimension. At the moment magpie_expand is only internally available in the
magclass library

In contrast to \code{\link{magpie_expand}} this function is expanding only a single
dimension. It is meant as a support function for \code{\link{magpie_expand}} itself.
}
\examples{
d <- new.magpie(c("AFR.BLUB.1", "AFR.BLUB.2", "EUR.BLUB.1",
                    "AFR.BLA.1", "AFR.BLA.2", "EUR.BLA.1"), fill = 1)
 getSets(d)[1:3] <- c("reg", "b", "i")
 e <- new.magpie(c("BLA.AFR.A", "BLA.EUR.A", "BLUB.AFR.A", "BLUB.EUR.A",
                    "BLA.AFR.B", "BLA.EUR.B", "BLUB.AFR.B", "BLUB.EUR.B"), fill = 2)
 getSets(e)[1:3] <- c("b", "reg", "a")
 magclass:::magpie_expand_dim(d, e, dim = 1)
}
\seealso{
\code{\link{as.magpie}}, \code{\link[base]{options}}
}
\author{
Jan Philipp Dietrich
}
