% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.r
\name{outer}
\alias{outer}
\alias{outer,ANY,ANY-method}
\alias{outer,madness,madness-method}
\alias{outer,madness,array-method}
\alias{outer,array,madness-method}
\alias{\%o\%}
\alias{kronecker,madness,madness-method}
\alias{kronecker,madness,madness-class}
\alias{kronecker,madness,array-method}
\alias{kronecker,madness,array-class}
\alias{kronecker,array,madness-method}
\alias{kronecker,array,madness-class}
\title{Outer product.}
\usage{
\S4method{outer}{ANY,ANY}(X, Y, FUN = "*", ...)

\S4method{outer}{madness,madness}(X, Y, FUN = "*", ...)

\S4method{outer}{madness,array}(X, Y, FUN = "*", ...)

\S4method{outer}{array,madness}(X, Y, FUN = "*", ...)

X \%o\% Y

\S4method{kronecker}{madness,madness}(X, Y)

\S4method{kronecker}{madness,array}(X, Y)

\S4method{kronecker}{array,madness}(X, Y)
}
\arguments{
\item{X, Y}{\code{madness} or numeric matrix values.}

\item{FUN}{a function to use on the outer products, found \emph{via}
    \code{\link[base]{match.fun}} (except for the special case \code{"*"}).}

\item{...}{optional arguments to be passed to \code{FUN}.}
}
\value{
a \code{madness} object.
}
\description{
Computes the outer product (or sum, quotient, etc) of the Cartesian
product of two inputs.
}
\examples{
set.seed(123)
y <- array(rnorm(3*3),dim=c(3,3))
dy <- matrix(rnorm(length(y)*2),ncol=2)
dx <- crossprod(matrix(rnorm(ncol(dy)*100),nrow=100))
obj0 <- madness(val=y,vtag='y',xtag='x',dvdx=dy,varx=dx)

y1 <- array(rnorm(3*3),dim=c(3,3))
dy1 <- matrix(rnorm(length(y1)*2),ncol=2)
dx1 <- crossprod(matrix(rnorm(ncol(dy1)*100),nrow=100))
obj1 <- madness(val=y1,vtag='y1',xtag='x',dvdx=dy1,varx=dx1)

anobj <- outer(obj0,obj0,'*')
anobj <- outer(obj0,obj0,'+')
anobj <- outer(obj0,obj1,'-')
anobj <- outer(obj0,obj1,'/')

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
