% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/made.r
\name{made.density}
\alias{made.density}
\title{Minimum Approximate Distance Estimate of Density Function with an optimal model degree}
\usage{
made.density(
  x,
  M0 = 1L,
  M,
  search = TRUE,
  interval = NULL,
  mar.deg = TRUE,
  method = c("qp", "em"),
  controls = mable.ctrl(),
  progress = TRUE
)
}
\arguments{
\item{x}{an \code{n x d} matrix or \code{data.frame} of multivariate sample of size \code{n}}

\item{M0}{a positive integer or a vector of \code{d} positive integers specify
starting candidate degrees for searching optimal degrees.}

\item{M}{a positive integer or a vector of \code{d} positive integers specify
the maximum candidate or the given model degrees for the joint density.}

\item{search}{logical, whether to search optimal degrees between \code{M0} and \code{M} 
or not but use \code{M} as the given model degrees for the joint density.}

\item{interval}{a vector of two endpoints or a \code{2 x d} matrix, each column containing 
the endpoints of support/truncation interval for each marginal density.
If missing, the i-th column is assigned as \code{c(min(x[,i]), max(x[,i]))}.}

\item{mar.deg}{logical, if TRUE, the optimal degrees are selected based
on marginal data, otherwise, the optimal degrees are chosen the joint data. See details.}

\item{method}{method for finding minimum distance estimate. "em": EM like method;}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
An invisible \code{mable} object with components
\itemize{
  \item \code{m} the given model degree(s) 
  \item \code{p} the estimated vector of mixture proportions 
      with the given optimal degree(s) \code{m}
  \item \code{interval} support/truncation interval \code{[a, b]}
  \item \code{D}  the minimum distance at degree \code{m}
 \item \code{convergence} An integer code. 0 indicates successful completion(the EM iteration is   
   convergent). 1 indicates that the iteration limit \code{maxit} had been reached in the EM iteration;
 }
}
\description{
Minimum Approximate Distance Estimate of Density Function with an optimal model degree
}
\details{
A \eqn{d}-variate cdf \eqn{F} on a hyperrectangle \eqn{[a, b]
  =[a_1, b_1] \times \cdots \times [a_d, b_d]} can be approximated 
  by a mixture of \eqn{d}-variate beta cdfs on \eqn{[a, b]}, 
  \eqn{\beta_{mj}(x) = \prod_{i=1}^dB_{m_i,j_i}[(x_i-a_i)/(b_i-a_i)]},
  with proportion \eqn{p(j_1, \ldots, j_d)}, \eqn{0 \le j_i \le m_i, i = 1, \ldots, d}. 
  With a given model degree \code{m}, the parameters \code{p}, the mixing
  proportions of the beta distribution, are calculated as the minimizer of the
  approximate \eqn{L_2} distance between the empirical distribution and 
  the Bernstein polynomial model. The quadratic programming with linear constraints
  is used to solve the problem.
  If \code{search=TRUE} then the model degrees are chosen using a method of change-point based on 
  the marginal data if \code{mar.deg=TRUE} or the joint data if \code{mar.deg=FALSE}. 
  If \code{search=FALSE}, then the model degree is specified by \eqn{M}.
}
