% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Tabulation}
\usage{
tab(data, ..., by = NULL, row.pct = TRUE, na.rm = FALSE, rnd = 1)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{row.pct}{\code{TRUE}, \code{FALSE} or \code{NULL}:

\code{TRUE} shows row percentages.

\code{FALSE} shows column percentages.

\code{NULL} shows no percentages.}

\item{na.rm}{A logical value to specify missing values,}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\value{
tabulation as \code{list}
}
\description{
\code{tab()} generates one-way or two-way tabulation of variables.
}
\details{
\strong{One-way tabulation}

If \code{by} is not specified, \code{tab} generates one-way tabulation of
a variable or multiple variables. \code{...} accepts multiple variables and
produces corresponding tabulations.

Tabulation is displayed in \code{Freq.} (frequency), \code{Percent.}
(Relative Frequency) and \code{Cum.Percent.} (Cumulative Relative frequency).

\preformatted{tab(data, var1)}

\preformatted{tab(data, var1, var2, var3:var5, var10)}

\strong{Two-way tabulation}

Specifying \code{by} produces two-way tables. P-values from
Chi-squared and Fisher's Exact tests are also shown.

\strong{Data type}

Tabulation of the whole dataset requires variables to be in either of
these data types: \code{character}, \code{factor}, \verb{order factor}, \code{logical}.
\subsection{if \code{...} is not specified, tabulation of the whole dataset is produced.}{

\preformatted{tab(data)}

\strong{Using colon \code{:} spearator}

Colon separator \code{:} can be used to indicate sequence of variables.

\preformatted{tab(data, var1, var2, var3:var5, var10)}
}
}
\examples{

## use infert data
data(infert)

## single variable
tab(infert, parity)

## multiple variables
tab(infert, parity, induced, case:pooled.stratum)

## tabulate the whole dataset
tab(infert)



## cross-tabulation
tab(infert, parity, by = case)
tab(infert, parity, by = case, row.pct = FALSE)
tab(infert, parity, by = case, row.pct = NULL)


## multiple variable
tab(infert, age, parity:spontaneous, education, by = case)

}
\references{
Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
