% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandTables.R
\name{expandTables}
\alias{expandTables}
\title{Convert \code{2x2 tables} to \code{data.frame}}
\usage{
expandTables(
  ...,
  exp_name = "exposure",
  exp_lvl = c("exposed", "unexposed"),
  case_name = "outcome",
  case_lvl = c("disease", "healthy"),
  strata_name = "strata",
  stringsAsFactors = FALSE
)
}
\arguments{
\item{...}{vectors of 2x2 tables}

\item{exp_name}{Name of \code{Exposure} Variable}

\item{exp_lvl}{Names of two categories in the order of
Exposed and non-exposed}

\item{case_name}{Name of \code{Case} variable}

\item{case_lvl}{names of two categories in the order of}

\item{strata_name}{Name of stratified variable}

\item{stringsAsFactors}{\code{TRUE} or \code{FALSE}

If \code{TRUE}, character vector is converted to a factor when
\code{data.frame} is constructed.}
}
\value{
\code{data.frame}
}
\description{
\code{expandTables()} generates a data frame and supports two levels.
}
\details{
\code{expandTables} uses the vectors of \code{2x2} tables and
generates a data frame of at least two columns:
Exposure and Outcome.

\preformatted{expandTables(c(100, 200, 100, 200))}

\strong{Strata}

Strata can be included using multiple named vectors. The
generated tables can be used for further calculation such as
Mantel Haenszel methods.

\preformatted{
expandTables(
             strata1 = c(100, 200, 100, 200),
             strata2 = c(100, 200, 100, 200),
             strata3 = c(100, 200, 100, 200),
             exp_name = "Exposure",
             exp_lvl = c("exposed", "unexposed"),
             case_name = "Outcome",
             case_lvl = c("case", "control"),
             strata_name = "Strata"
)
}

\strong{Labels}

If variables' names or levels are not specified, the followings are
applied.

\enumerate{
\item Exposure Name: \code{exposure}
\item Exposure levels: \code{exposed} and \code{unexposed}
\item Outcome Name: \code{outcome}
\item Outcome levels: \code{disease} and \code{healthy}
\item Strata Name: \code{strata}
\item Note: Strata levels are not considered as vectors must
be named.
}
}
\examples{


## Asthma Example from Essential Medical Statistics
## page 160

asthma <- expandTables(c(81, 995, 57, 867),
              exp_name = "sex",
              exp_lvl = c("woman", "man"),
              case_name = "asthma",
              case_lvl = c("yes", "no"))

## label variable and dataset
asthma <- labelData(asthma, "Hypothetical Data of Asthma Prevalence")
asthma <- labelVar(asthma, c(sex, asthma), c("Man or Woman", "Asthma or No Asthma"))

## Checking codebook
codebook(asthma)


## simple tabulation
tab(asthma)

## cross-tabulation
tab(asthma, sex, by = asthma)


}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
