% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete-msg.R
\name{delete_msg}
\alias{delete_msg}
\title{Delete Messages}
\usage{
delete_msg(imapconf, msg_id, by = "MSN", retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
An (invisible) \code{list} of length \code{2} containing the
    \code{imapconf} object and the previously inputed message ids
    (parameter \code{msg_id}).
}
\description{
Deletes messages from a mailbox.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# deleting based on search results
result1 <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #modified pipe operator - pass two argg
    delete_msg(imapconf = imapconf, msg_id = msg_id)


# deleting a specific msg_id without a previous search
result2 <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    delete_msg(msg_id = 66128)

}

}
\seealso{
Other miscellaneous: \code{\link{add_flags}},
  \code{\link{copy_msg}}, \code{\link{count_msgs}},
  \code{\link{expunge}}, \code{\link{get_max_id}},
  \code{\link{get_min_id}}, \code{\link{move_msg}},
  \code{\link{remove_flags}}, \code{\link{replace_flags}}
}
\concept{miscellaneous}
