% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-searchrequest-size.R
\name{define_searchrequest_size}
\alias{define_searchrequest_size}
\title{Size Search Request}
\usage{
define_searchrequest_size(operation, size, negate, by, flag, esearch,
  handle)
}
\arguments{
\item{operation}{A character indicating which custom operation to execute.}

\item{size}{An integer specifying the size (in number of characters) of
message to be used as search criterion.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{flag}{Optional parameter that adds a flag filter to the search. Use
\link{flag_options} to list the common flags used by IMAP servers.
Default is \code{NULL}.}

\item{esearch}{A logical. Default is \code{FALSE}. If the IMAP server has
\code{ESEARCH} capability, it can be used to optimize search results. It
allows to condense results to message sets to cut down on transmission
costs, e.g. \code{1:5} instead of writing ids individually such as
code{1,2,3,4,5}. It can be used along with buffersize to avoid results
stripping. Check if your IMAP server supports \code{SEARCH} with
\code{\link{list_server_capabilities}}.}

\item{handle}{A curl handle object.}
}
\value{
A curl handle object containing the custom request.
}
\description{
Internal helper function for defining curl custom request to be
    used with each search function
}
\seealso{
Other search helper: \code{\link{check_args_custom_search}},
  \code{\link{check_args_search_date}},
  \code{\link{check_args_search_flag}},
  \code{\link{check_args_search_period}},
  \code{\link{check_args_search_size}},
  \code{\link{check_args_search_string}},
  \code{\link{check_args_search_within}},
  \code{\link{define_searchrequest_custom}},
  \code{\link{define_searchrequest_date}},
  \code{\link{define_searchrequest_flag}},
  \code{\link{define_searchrequest_period}},
  \code{\link{define_searchrequest_string}},
  \code{\link{define_searchrequest_within}},
  \code{\link{fix_search_stripping}}

Other define searchrequest: \code{\link{define_searchrequest_custom}},
  \code{\link{define_searchrequest_date}},
  \code{\link{define_searchrequest_flag}},
  \code{\link{define_searchrequest_period}},
  \code{\link{define_searchrequest_string}},
  \code{\link{define_searchrequest_within}}
}
\concept{define searchrequest}
\concept{search helper}
\keyword{internal}
