% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module0_maincall.R
\name{mMARCH.AC.maincall}
\alias{mMARCH.AC.maincall}
\title{Main Call for Data Processing after Runing GGIR for Accelerometer Data}
\usage{
mMARCH.AC.maincall(
  mode,
  useIDs.FN = NULL,
  currentdir,
  studyname,
  bindir = NULL,
  outputdir,
  epochIn = 5,
  epochOut = 60,
  log.multiplier = 9250,
  use.cluster = TRUE,
  QCdays.alpha = 7,
  QChours.alpha = 16,
  QCnights.feature.alpha = c(0, 0),
  DoubleHour = c("average", "earlier", "later")[1],
  QC.sleepdur.avg = c(3, 12),
  QC.nblocks.sleep.avg = c(5, 30),
  Rversion = "R",
  filename2id = NULL,
  PA.threshold = c(50, 100, 400),
  desiredtz = "US/Eastern",
  RemoveDaySleeper = FALSE,
  part5FN = "WW_L50M100V400_T5A5",
  NfileEachBundle = 20,
  holidayFN = NULL,
  trace = FALSE
)
}
\arguments{
\item{mode}{\code{number} Specify which of the five modules need to be run, e.g. mode = 0 makes that all R/Rmd/sh files are generated for other modules. When mode = 1, all csv files in the GGIR output directory were read, transformed and then merged. When mode = 2, the GGIR output files were checked and summarized in one excel sheet. When mode = 3, the merged data was cleaned according to the number of valid hours on each night and the number of valid days for each subject. When mode = 4, the cleaned data was imputed.}

\item{useIDs.FN}{\code{character} Filename with or without directory for sample information in CSV format, which including "filename" and "duplicate" in the headlines at least. If duplicate="remove",  the accelerometer files will not be used in the data analysis of module 5-7. Defaut is NULL, which makes all accelerometer files will be used in module 5-7.}

\item{currentdir}{\code{character} Directory where the output needs to be stored. Note that this directory must exist.}

\item{studyname}{\code{character} Specify the study name that used in the output file names}

\item{bindir}{\code{character} Directory where the accelerometer files are stored or list}

\item{outputdir}{\code{character} Directory where the GGIR output was stored.}

\item{epochIn}{\code{number}  Epoch size to which acceleration was averaged (seconds) in GGIR output. Defaut is 5 seconds.}

\item{epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in module 3. Defaut is 60 seconds.}

\item{log.multiplier}{\code{number} The coefficient used in the log transformation of the ENMO data, i.e. log( log.multiplier * ENMO + 1), which have been used in module 5-7. Defaut is 9250.}

\item{use.cluster}{\code{logical}  Specify if module1 will be done by parallel computing. Default is TRUE, and the CSV file in GGIR output will be merged for every 20 files first, and then combined for all.}

\item{QCdays.alpha}{\code{number}  Minimum required number of valid days in subject specific analysis as a quality control step in module2. Default is 7 days.}

\item{QChours.alpha}{\code{number}  Minimum required number of valid hours in day specific analysis as a quality control step in module2. Default is 16 hours.}

\item{QCnights.feature.alpha}{\code{number}  Minimum required number of valid nights in day specific mean, SD, weekday mean and weekend mean analysis as a quality control step in the JIVE analysis. Default is  c(0,0,0,0), i.e. no additional data cleaning in this step.}

\item{DoubleHour}{\code{character}  Specify the method of processing the double hours for days that daylight saving time starts and ends for example. In detail, DoubleHour = c("average","earlier","later"). The acceleration data was averaged on double hours when DoulbeHour="average". Only the acceleration data in the earlier occurrence was remained for double hours while the other duplicate data were ignored when DoulbeHour="earlier". Only the acceleration data in the later occurrence was remained for double hours while the other duplicate data were ignored when DoulbeHour="later".  Default is "average".}

\item{QC.sleepdur.avg}{\code{number}  As taking the deault value of QC.sleepdur.avg=c(3,12), individuals were excluded with an average sleep duration <3 hour or >12 hour.}

\item{QC.nblocks.sleep.avg}{\code{number}  As taking the deault value of QC.nblocks.sleep.avg=c(5,30), individuals were excluded with an average number of nocturnal sleep episodes <5 or >30.}

\item{Rversion}{\code{character}  R version, eg. "R/3.6.3". Default is "R".}

\item{filename2id}{\code{R function}  User defined function for converting filename to sample IDs. Default is NULL.}

\item{PA.threshold}{\code{number}  Threshold for light, moderate and vigorous physical activity. Default is c(50,100,400).}

\item{desiredtz}{\code{charcter}  desired timezone: see also http://en.wikipedia.org/wiki/Zone.tab. Used in g.inspectfile(). Default is "US/Eastern". Used in g.inspectfile() function to inspect acceleromether file for brand, sample frequency in module 2.}

\item{RemoveDaySleeper}{\code{logical}  Specify if the daysleeper nights are removed from the calculation of number of valid days for each subject. Default is FALSE.}

\item{part5FN}{\code{character}  Specify which output is used in the GGIR part5 results. Defaut is "WW_L50M100V400_T5A5", which means that part5_daysummary_WW_L50M100V400_T5A5.csv and part5_personsummary_WW_L50M100V400_T5A5.csv are used in the analysis.}

\item{NfileEachBundle}{\code{number}  Number of files in each bundle when the csv data were read and processed in a cluster. Default is 20.}

\item{holidayFN}{\code{character}  Specify the holiday file including filename (optional), Date (mm/dd/year) and holiday (1/0) columns. When it is available, the holiday will be marked into the "weekends" group in weekday/weekend specific feature calculations in module7d. Defaut is NULL.}

\item{trace}{\code{logical}  Specify if the intermediate results is printed when the function was executed. Default is FALSE.}
}
\value{
See mMARCH.AC manual for details.
}
\description{
This R script will generate all necessary R/Rmd/shell files for data processing after running GGIR for accelerometer data.
}
