% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgreementBudget.R
\docType{methods}
\name{AgreementBudget}
\alias{AgreementBudget}
\alias{AgreementBudget,ThreeMapComparison-method}
\alias{AgreementBudget,RasterLayer-method}
\title{Create an AgreementBudget object}
\usage{
AgreementBudget(x, ...)

\S4method{AgreementBudget}{ThreeMapComparison}(x, ...)

\S4method{AgreementBudget}{RasterLayer}(x, ...)
}
\arguments{
\item{x}{a ThreeMapComparison object or RasterLayer}

\item{\dots}{additional arguments to ThreeMapComparison. Only required if x is
not a ThreeMapComparison object}
}
\value{
An \code{AgreementBudget} object.
}
\description{
This function quantifies sources of agreement and disagreement between a
reference map for time 1, a reference map for time 2 and a simulated map for
time 2 to provide meaningful information about the performance of land use
change simulations.
}
\details{
The types of agreement and disagreement considered are those descibed in
Pontius et al. (2011):

\enumerate{
  \item Persistence simulated correctly (agreement)
  \item Persistence simulated as change (disagreement)
  \item Change simulated incorrectly (disagreement)
  \item Change simulated correctly (agreement)
  \item Change simulated as persistence (disagreement)
}
}
\examples{

## see lulcc-package examples
}
\references{
Pontius Jr, R.G., Peethambaram, S., Castella, J.C. (2011).
Comparison of three maps at multiple resolutions: a case study of land change
simulation in Cho Don District, Vietnam. Annals of the Association of American
Geographers 101(1): 45-62.
}
\seealso{
\code{\link{AgreementBudget-class}},
\code{\link{plot.AgreementBudget}}, \code{\link{ThreeMapComparison}},
\code{\link{FigureOfMerit}}
}
