% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwltsspca.R
\name{ltsspcaRw}
\alias{ltsspcaRw}
\title{Reweighted LTS-SPCA}
\usage{
ltsspcaRw(x, obj, k = NULL, alpha = 0.5, co.sd = 0.25)
}
\arguments{
\item{x}{the input data matrix}

\item{obj}{initial LTS-SPCA object given by ltsspca function}

\item{k}{dimension of the PC subspace; by default is NULL then k takes the value of kmax in the initial LTS-SPCA}

\item{alpha}{the robust parameter which takes value between 0 to 0.5, default is 0.5}

\item{co.sd}{cutoff value for score outlier weight, default is 0.25}
}
\value{
the object of class "ltsspcaRw" is returned \cr
\item{loadings}{the sparse loading matrix estimated with reweighted LTS-SPCA}
\item{scores}{the estimated score matrix}
\item{eigenvalues}{the estimated eigenvalues}
\item{mu}{the center estimate}
\item{rw.obj}{the list that contains the results of sPCA_rSVD on the reduced data}
\item{od}{the orthonal distances with respect to the initially estimated PC subspace with all the noisy variables removed}
\item{co.od}{the cutoff value for the orthogonal distances}
\item{ws.od}{if the observation is outlying in the orthgonal complement of the initially estimated PC subspace \code{ws.od}=0; otherwise \code{ws.od}=1}
\item{sc.wt}{the score outlier weight, which is compared with 0.25 (by default) to flag score outliers}
\item{co.sd}{the cutoff value for score outlier weight, default is 0.25}
\item{ws.sd}{if the observation is outlying with the PC subspace \code{ws.sd}=0; otherwise \code{ws.sd}=1}
\item{sc.out}{the retruned object when computing the score outlier weights}
}
\description{
the function that computes the reweighted LTS-SPCA
}
