% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanheatmap.R
\name{meanheatmap}
\alias{meanheatmap}
\title{Plot Heatmap of A Matrix}
\usage{
meanheatmap(x)
}
\arguments{
\item{x}{Matrix or list of matrices to be plotted}
}
\description{
Construct a heatmap of a matrix using \pkg{ggplot2}.
}
\examples{
set.seed(1)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(6, 6), nclust = c(5, 4, 6, 5))
meanheatmap(Map(tcrossprod, dat[[1]]$interactions$C, dat[[1]]$interactions$D))
}
