% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{powerOnePropExact}
\alias{powerOnePropExact}
\title{Power for binomial one-sample exact test}
\usage{
powerOnePropExact(n = NA_real_, piH0 = NA_real_, pi = NA_real_, alpha = 0.025)
}
\arguments{
\item{n}{The sample size.}

\item{piH0}{The response probability under the null hypothesis.}

\item{pi}{The response probability under the alternative hypothesis.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
A data frame containing the critical value of the number of
responses for rejecting the null hypothesis, the attained type I
error, the power for the exact test, the sample size, the
response probabilities under the null and alternative hypotheses,
and the direction of the alternative.
}
\description{
Obtains the power for binomial one-sample exact test.
}
\examples{
powerOnePropExact(n = 110, piH0 = 0.15, pi = 0.25, alpha = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
