% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fstdmix}
\alias{fstdmix}
\title{Adjusted p-values for standard mixture gatekeeping procedures}
\usage{
fstdmix(
  p,
  family = NULL,
  serial,
  parallel,
  gamma,
  test = "hommel",
  exhaust = 1
)
}
\arguments{
\item{p}{The raw p-values for elementary hypotheses.}

\item{family}{The matrix of family indicators for the hypotheses.}

\item{serial}{The matrix of serial rejection set for the hypotheses.}

\item{parallel}{The matrix of parallel rejection set for the hypotheses.}

\item{gamma}{The truncation parameters for each family.}

\item{test}{The component multiple testing procedure. It is either "Holm"
or "Hochberg", and it defaults to "Hochberg".}

\item{exhaust}{Whether to use alpha-exhausting component testing procedure
for the last family with active hypotheses. It defaults to TRUE.}
}
\value{
A matrix of adjusted p-values.
}
\description{
Obtains the adjusted p-values for the standard gatekeeping
procedures for multiplicity problems involving serial and parallel
logical restrictions.
}
\examples{

p = c(0.0194, 0.0068, 0.0271, 0.0088, 0.0370, 0.0018, 0.0814, 0.0066)
family = matrix(c(1, 1, 0, 0, 0, 0, 0, 0, 
                  0, 0, 1, 1, 0, 0, 0, 0, 
                  0, 0, 0, 0, 1, 1, 0, 0, 
                  0, 0, 0, 0, 0, 0, 1, 1), 
                nrow=4, byrow=TRUE)

serial = matrix(c(0, 0, 0, 0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0,
                  1, 0, 0, 0, 0, 0, 0, 0,
                  0, 1, 0, 0, 0, 0, 0, 0,
                  0, 0, 1, 0, 0, 0, 0, 0,
                  0, 0, 0, 1, 0, 0, 0, 0,
                  0, 0, 0, 0, 1, 0, 0, 0,
                  0, 0, 0, 0, 0, 1, 0, 0), 
                nrow=8, byrow=TRUE)
 
parallel = matrix(0, 8, 8)
gamma = c(0.6, 0.6, 0.6, 1)
fstdmix(p, family, serial, parallel, gamma, "hommel", 0)

}
\references{
Alex Dmitrienko and Ajit C Tamhane. Mixtures of multiple testing
procedures for gatekeeping applications in clinical trials.
Statistics in Medicine. 2011; 30(13):1473–1488.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
