# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Log-rank test simulation
#' @description Performs simulation for two-arm group sequential
#' trials based on weighted log-rank test.
#'
#' @inheritParams param_kMax
#' @param informationRates The information rates in terms of number 
#'   of events for the conventional log-rank test and in terms of 
#'   the actual information for weighted log-rank tests.   
#'   Fixed prior to the trial. If left unspecified, it defaults to
#'   \code{plannedEvents / plannedEvents[kMax]} when \code{plannedEvents} 
#'   is provided and to \code{plannedTime / plannedTime[kMax]} otherwise.
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @inheritParams param_hazardRatioH0
#' @param allocation1 Number of subjects in the active treatment group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at each
#'   stage.
#' @param plannedTime The calendar times for the analyses. To use calendar  
#'   time to plan the analyses, \code{plannedEvents} should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return An S3 class \code{lrsim} object with 3 components:
#'
#' * \code{overview}: A list containing the following information:
#' 
#'   - \code{rejectPerStage}: The efficacy stopping probability by stage.
#'   
#'   - \code{futilityPerStage}: The futility stopping probability by stage.
#'   
#'   - \code{cumulativeRejection}: Cumulative efficacy stopping 
#'   probability by stage.
#'   
#'   - \code{cumulativeFutility}: The cumulative futility stopping 
#'   probability by stage.
#'   
#'   - \code{numberOfEvents}: The average number of events by stage.
#'   
#'   - \code{numberOfDropouts}: The average number of dropouts by stage.
#'   
#'   - \code{numberOfSubjects}: The average number of subjects by stage.
#'   
#'   - \code{analysisTime}: The average analysis time by stage.
#'   
#'   - \code{overallReject}: The overall rejection probability. 
#'   
#'   - \code{expectedNumberOfEvents}: The expected number of events for 
#'   the overall study.
#'   
#'   - \code{expectedNumberOfDropouts}: The expected number of dropouts for
#'   the overall study.
#'   
#'   - \code{expectedNumberOfSubjects}: The expected number of subjects for 
#'   the overall study. 
#'   
#'   - \code{expectedStudyDuration}: The expected study duration.
#'   
#'   - \code{hazardRatioH0}: Hazard ratio under the null hypothesis for 
#'   the active treatment versus control.
#'   
#'   - \code{useEvents}: whether the analyses are planned 
#'   based on the number of events or calendar time. 
#'   
#'   - \code{accrualDuration}: Duration of the enrollment period.
#'   
#'   - \code{fixedFollowup}: Whether a fixed follow-up design is used.
#'   
#'   - \code{rho1}: The first parameter of the Fleming-Harrington family 
#'   of weighted log-rank test. Defaults to 0 for conventional log-rank test.
#'   
#'   - \code{rho2}: The second parameter of the Fleming-Harrington family 
#'   of weighted log-rank test. Defaults to 0 for conventional log-rank test.
#'   
#'   - \code{kMax}: The maximum number of stages.
#'
#' * \code{sumdata}: A data frame of summary data by iteration and stage: 
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{stopStage}: The stage at which the trial stops.
#'   
#'   - \code{eventsNotAchieved}: Whether the target number of events 
#'   is not achieved for the iteration.
#'   
#'   - \code{stageNumber}: The stage number, covering all stages even if 
#'   the trial stops at an interim look.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{accruals1}: The number of subjects enrolled at the stage for
#'   the treatment group.
#'   
#'   - \code{accruals2}: The number of subjects enrolled at the stage for
#'   the control group.
#'   
#'   - \code{totalAccruals}: The total number of subjects enrolled at 
#'   the stage.
#'   
#'   - \code{events1}: The number of events at the stage for 
#'   the treatment group.
#'   
#'   - \code{events2}: The number of events at the stage for 
#'   the control group.
#'   
#'   - \code{totalEvents}: The total number of events at the stage.
#'   
#'   - \code{dropouts1}: The number of dropouts at the stage for 
#'   the treatment group. 
#'   
#'   - \code{dropouts2}: The number of dropouts at the stage for 
#'   the control group.
#'   
#'   - \code{totalDropouts}: The total number of dropouts at the stage.
#'   
#'   - \code{uscore}: The numerator of the log-rank test statistic. 
#'   
#'   - \code{vscore}: The variance of the log-rank test statistic.
#'   
#'   - \code{logRankStatistic}: The log-rank test Z-statistic.
#'   
#'   - \code{rejectPerStage}: Whether to reject the null hypothesis 
#'   at the stage.
#'   
#'   - \code{futilityPerStage}: Whether to stop the trial for futility  
#'   at the stage.
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer): A data frame for subject-level data for selected
#' replications, containing the following variables:
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{stopStage}: The stage at which the trial stops.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{subjectId}: The subject ID.
#'   
#'   - \code{arrivalTime}: The enrollment time for the subject.
#'   
#'   - \code{stratum}: The stratum for the subject.
#'   
#'   - \code{treatmentGroup}: The treatment group (1 or 2) for the subject.
#'   
#'   - \code{survivalTime}: The underlying survival time for the subject.
#'   
#'   - \code{dropoutTime}: The underlying dropout time for the subject.
#'   
#'   - \code{timeUnderObservation}: The time under observation since    
#'   since randomization.
#'   
#'   - \code{event}: Whether the subject experienced the event.
#'   
#'   - \code{dropoutEvent}: Whether the subject dropped out.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Example 1: analyses based on number of events
#' 
#' sim1 = lrsim(kMax = 2, informationRates = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedEvents = c(60, 120),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim1
#'
#' # summary for each simulated data set
#' head(sim1$sumdata)
#'
#' # raw data for selected replication
#' head(sim1$rawdata)
#'
#'
#' # Example 2: analyses based on calendar time have similar power
#'
#' sim2 = lrsim(kMax = 2, informationRates = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedTime = c(31.9, 113.2),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim2
#'
#' # summary for each simulated data set
#' head(sim2$sumdata)
#' 
#' @export
lrsim <- function(kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, hazardRatioH0 = 1, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim`, kMax, informationRates, criticalValues, futilityBounds, hazardRatioH0, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for three arms
#' @description Performs simulation for three-arm group sequential trials 
#' based on weighted log-rank test. The looks are driven by the total 
#' number of events in Arm A and Arm C combined. Alternatively, 
#' the analyses can be planned to occur at specified calendar times.
#' 
#' @inheritParams param_kMax
#' @param hazardRatioH013 Hazard ratio under the null hypothesis for arm 1
#'   versus arm 3. Defaults to 1 for superiority test.
#' @param hazardRatioH023 Hazard ratio under the null hypothesis for arm 2
#'   versus arm 3. Defaults to 1 for superiority test.
#' @param hazardRatioH012 Hazard ratio under the null hypothesis for arm 1
#'   versus arm 2. Defaults to 1 for superiority test.
#' @param allocation1 Number of subjects in Arm A in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in Arm B in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation3 Number of subjects in Arm C in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param lambda1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1.
#' @param lambda2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2.
#' @param lambda3 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3.
#' @param gamma1 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1.
#' @param gamma2 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2.
#' @param gamma3 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3.
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at 
#'   Look 1 to Look \code{kMax} for Arms A and C combined.
#' @param plannedTime The calendar times for the analyses. To use calendar  
#'   time to plan the analyses, \code{plannedEvents} should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata}: A data frame of summary data by iteration and stage: 
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{eventsNotAchieved}: Whether the target number of events 
#'   is not achieved for the iteration.
#'   
#'   - \code{stageNumber}: The stage number, covering all stages even if 
#'   the trial stops at an interim look.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{accruals1}: The number of subjects enrolled at the stage for
#'   the active treatment 1 group.
#'   
#'   - \code{accruals2}: The number of subjects enrolled at the stage for
#'   the active treatment 2 group.
#'   
#'   - \code{accruals3}: The number of subjects enrolled at the stage for
#'   the control group.
#'   
#'   - \code{totalAccruals}: The total number of subjects enrolled at 
#'   the stage.
#'   
#'   - \code{events1}: The number of events at the stage for 
#'   the active treatment 1 group.
#'   
#'   - \code{events2}: The number of events at the stage for 
#'   the active treatment 2 group.
#'   
#'   - \code{events3}: The number of events at the stage for 
#'   the control group.
#'   
#'   - \code{totalEvents}: The total number of events at the stage.
#'   
#'   - \code{dropouts1}: The number of dropouts at the stage for 
#'   the active treatment 1 group. 
#'   
#'   - \code{dropouts2}: The number of dropouts at the stage for 
#'   the active treatment 2 group.
#'   
#'   - \code{dropouts3}: The number of dropouts at the stage for 
#'   the control group.
#'   
#'   - \code{totalDropouts}: The total number of dropouts at the stage.
#'   
#'   - \code{logRankStatistic13}: The log-rank test Z-statistic 
#'   comparing the active treatment 1 to the control.
#'   
#'   - \code{logRankStatistic23}: The log-rank test Z-statistic 
#'   comparing the active treatment 2 to the control.
#'   
#'   - \code{logRankStatistic12}: The log-rank test Z-statistic 
#'   comparing the active treatment 1 to the active treatment 2.
#'   
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer): A data frame for subject-level data for selected
#' replications, containing the following variables:
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{stageNumber}: The stage under consideration.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{subjectId}: The subject ID.
#'   
#'   - \code{arrivalTime}: The enrollment time for the subject.
#'   
#'   - \code{stratum}: The stratum for the subject.
#'   
#'   - \code{treatmentGroup}: The treatment group (1, 2, or 3) for 
#'   the subject.
#'   
#'   - \code{survivalTime}: The underlying survival time for the subject.
#'   
#'   - \code{dropoutTime}: The underlying dropout time for the subject.
#'   
#'   - \code{timeUnderObservation}: The time under observation since 
#'   since randomization for the subject.
#'   
#'   - \code{event}: Whether the subject experienced the event.
#'   
#'   - \code{dropoutEvent}: Whether the subject dropped out. 
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' 
#' sim1 = lrsim3a(
#'   kMax = 3, 
#'   allocation1 = 2, 
#'   allocation2 = 2, 
#'   allocation3 = 1,
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   lambda1 = log(2)/12*0.60,
#'   lambda2 = log(2)/12*0.70,
#'   lambda3 = log(2)/12,
#'   accrualDuration = 30.143,
#'   plannedEvents = c(186, 259, 295),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'   
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#' 
#' @export
lrsim3a <- function(kMax = NA_integer_, hazardRatioH013 = 1, hazardRatioH023 = 1, hazardRatioH012 = 1, allocation1 = 1L, allocation2 = 1L, allocation3 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, lambda3 = NA_real_, gamma1 = 0L, gamma2 = 0L, gamma3 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim3a`, kMax, hazardRatioH013, hazardRatioH023, hazardRatioH012, allocation1, allocation2, allocation3, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, lambda3, gamma1, gamma2, gamma3, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for two endpoints and two arms
#' @description Performs simulation for two-endpoint two-arm group 
#' sequential trials based on weighted log-rank test. The first \code{kMaxe1} 
#' looks are driven by the total number of PFS events in two arms 
#' combined, and the subsequent looks are driven by the total 
#' number of OS events in two arms combined. Alternatively, 
#' the analyses can be planned to occur at specified calendar times.
#' 
#' @inheritParams param_kMax
#' @param kMaxe1 Number of stages with timing determined by PFS events. 
#'   Ranges from 0 (none) to \code{kMax}. 
#' @param hazardRatioH0e1 Hazard ratio under the null hypothesis for the 
#'   active treatment vs control for endpoint 1 (PFS). Defaults to 1 for 
#'   superiority test.
#' @param hazardRatioH0e2 Hazard ratio under the null hypothesis for the 
#'   active treatment vs control for endpoint 2 (OS). Defaults to 1 for 
#'   superiority test.
#' @param allocation1 Number of subjects in the treatment group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param rho The correlation coefficient for the standard bivariate normal
#'   random variables used to generate time to disease progression and time 
#'   to death using the inverse CDF method.
#' @param lambda1e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the treatment group and endpoint 1 (PFS).
#' @param lambda2e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the control group and endpoint 1 (PFS).
#' @param lambda1e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the treatment group and endpoint 2 (OS).
#' @param lambda2e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the control group and endpoint 2 (OS).
#' @param gamma1e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the treatment group and endpoint 1 (PFS).
#' @param gamma2e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the control group and endpoint 1 (PFS).
#' @param gamma1e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the treatment group and endpoint 2 (OS).
#' @param gamma2e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the control group and endpoint 2 (OS).
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of PFS events at 
#'   Look 1 to Look kMaxe1 and the planned cumulative total number of OS 
#'   events at Look kMaxe1+1 to Look kMax.
#' @param plannedTime The calendar times for the analyses. To use calendar  
#'   time to plan the analyses, \code{plannedEvents} should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata}: A data frame of summary data by iteration and stage: 
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{eventsNotAchieved}: Whether the target number of events 
#'   is not achieved for the iteration.
#'   
#'   - \code{stageNumber}: The stage number, covering all stages even if 
#'   the trial stops at an interim look.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{accruals1}: The number of subjects enrolled at the stage for
#'   the treatment group.
#'   
#'   - \code{accruals2}: The number of subjects enrolled at the stage for
#'   the control group.
#'   
#'   - \code{totalAccruals}: The total number of subjects enrolled at 
#'   the stage.
#'   
#'   - \code{endpoint}: The endpoint (1 or 2) under consideration.
#'   
#'   - \code{events1}: The number of events at the stage for 
#'   the treatment group.
#'   
#'   - \code{events2}: The number of events at the stage for 
#'   the control group.
#'   
#'   - \code{totalEvents}: The total number of events at the stage.
#'   
#'   - \code{dropouts1}: The number of dropouts at the stage for 
#'   the treatment group. 
#'   
#'   - \code{dropouts2}: The number of dropouts at the stage for 
#'   the control group.
#'   
#'   - \code{totalDropouts}: The total number of dropouts at the stage.
#'   
#'   - \code{logRankStatistic}: The log-rank test Z-statistic for 
#'   the endpoint.
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer): A data frame for subject-level data for selected
#' replications, containing the following variables:
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{stageNumber}: The stage under consideration.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{subjectId}: The subject ID.
#'   
#'   - \code{arrivalTime}: The enrollment time for the subject.
#'   
#'   - \code{stratum}: The stratum for the subject.
#'   
#'   - \code{treatmentGroup}: The treatment group (1 or 2) for the subject.
#'   
#'   - \code{survivalTime1}: The underlying survival time for 
#'   event endpoint 1 for the subject.
#'   
#'   - \code{dropoutTime1}: The underlying dropout time for 
#'   event endpoint 1 for the subject.
#'   
#'   - \code{timeUnderObservation1}: The time under observation since 
#'   since randomization for event endpoint 1 for the subject.
#'   
#'   - \code{event1}: Whether the subject experienced event endpoint 1.
#'   
#'   - \code{dropoutEvent1}: Whether the subject dropped out for 
#'   endpoint 1.
#'   
#'   - \code{survivalTime2}: The underlying survival time for 
#'   event endpoint 2 for the subject.
#'   
#'   - \code{dropoutTime2}: The underlying dropout time for 
#'   event endpoint 2 for the subject.
#'   
#'   - \code{timeUnderObservation2}: The time under observation since 
#'   since randomization for event endpoint 2 for the subject.
#'   
#'   - \code{event2}: Whether the subject experienced event endpoint 2.
#'   
#'   - \code{dropoutEvent2}: Whether the subject dropped out for 
#'   endpoint 2.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' 
#' sim1 = lrsim2e(
#'   kMax = 3, 
#'   kMaxe1 = 2,
#'   allocation1 = 2, 
#'   allocation2 = 1, 
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   rho = 0,
#'   lambda1e1 = log(2)/12*0.60,
#'   lambda2e1 = log(2)/12,
#'   lambda1e2 = log(2)/30*0.65, 
#'   lambda2e2 = log(2)/30,
#'   accrualDuration = 20.143,
#'   plannedEvents = c(186, 259, 183),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'  
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#' 
#' @export
lrsim2e <- function(kMax = NA_integer_, kMaxe1 = NA_integer_, hazardRatioH0e1 = 1, hazardRatioH0e2 = 1, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, rho = 0, lambda1e1 = NA_real_, lambda2e1 = NA_real_, lambda1e2 = NA_real_, lambda2e2 = NA_real_, gamma1e1 = 0L, gamma2e1 = 0L, gamma1e2 = 0L, gamma2e2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim2e`, kMax, kMaxe1, hazardRatioH0e1, hazardRatioH0e2, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, rho, lambda1e1, lambda2e1, lambda1e2, lambda2e2, gamma1e1, gamma2e1, gamma1e2, gamma2e2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for two endpoints and three arms
#' @description Performs simulation for two-endpoint three-arm group 
#' sequential trials based on weighted log-rank test. The first \code{kMaxe1} 
#' looks are driven by the total number of PFS events in Arm A 
#' and Arm C combined, and the subsequent looks are driven by the total 
#' number of OS events in Arm A and Arm C combined. Alternatively, 
#' the analyses can be planned to occur at specified calendar times. 
#' 
#' @inheritParams param_kMax
#' @param kMaxe1 Number of stages with timing determined by PFS events. 
#'   Ranges from 0 (none) to \code{kMax}. 
#' @param hazardRatioH013e1 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH023e1 Hazard ratio under the null hypothesis for arm 2 
#'   vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH012e1 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 2 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH013e2 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param hazardRatioH023e2 Hazard ratio under the null hypothesis for arm 2 
#'   vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param hazardRatioH012e2 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 2 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param allocation1 Number of subjects in Arm A in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in Arm B in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation3 Number of subjects in Arm C in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param rho The correlation coefficient for the standard bivariate normal
#'   random variables used to generate time to disease progression and time 
#'   to death using the inverse CDF method.
#' @param lambda1e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1 and endpoint 1 (PFS).
#' @param lambda2e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2 and endpoint 1 (PFS).
#' @param lambda3e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3 and endpoint 1 (PFS).
#' @param lambda1e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1 and endpoint 2 (OS).
#' @param lambda2e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2 and endpoint 2 (OS).
#' @param lambda3e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3 and endpoint 2 (OS).
#' @param gamma1e1 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1 and endpoint 1 (PFS).
#' @param gamma2e1 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2 and endpoint 1 (PFS).
#' @param gamma3e1 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3 and endpoint 1 (PFS).
#' @param gamma1e2 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1 and endpoint 2 (OS).
#' @param gamma2e2 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2 and endpoint 2 (OS).
#' @param gamma3e2 The hazard rate for exponential dropout. A vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3 and endpoint 2 (OS).
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of PFS events at 
#'   Look 1 to Look kMaxe1 for Arms A and C combined and the planned 
#'   cumulative total number of OS events at Look kMaxe1+1 to Look kMax 
#'   for Arms A and C combined.
#' @param plannedTime The calendar times for the analyses. To use calendar  
#'   time to plan the analyses, \code{plannedEvents} should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata}: A data frame of summary data by iteration and stage: 
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{eventsNotAchieved}: Whether the target number of events 
#'   is not achieved for the iteration.
#'   
#'   - \code{stageNumber}: The stage number, covering all stages even if 
#'   the trial stops at an interim look.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{accruals1}: The number of subjects enrolled at the stage for
#'   the active treatment 1 group.
#'   
#'   - \code{accruals2}: The number of subjects enrolled at the stage for
#'   the active treatment 2 group.
#'   
#'   - \code{accruals3}: The number of subjects enrolled at the stage for
#'   the control group.
#'   
#'   - \code{totalAccruals}: The total number of subjects enrolled at 
#'   the stage.
#'   
#'   - \code{endpoint}: The endpoint (1 or 2) under consideration.
#'   
#'   - \code{events1}: The number of events at the stage for 
#'   the active treatment 1 group.
#'   
#'   - \code{events2}: The number of events at the stage for 
#'   the active treatment 2 group.
#'   
#'   - \code{events3}: The number of events at the stage for 
#'   the control group.
#'   
#'   - \code{totalEvents}: The total number of events at the stage.
#'   
#'   - \code{dropouts1}: The number of dropouts at the stage for 
#'   the active treatment 1 group. 
#'   
#'   - \code{dropouts2}: The number of dropouts at the stage for 
#'   the active treatment 2 group.
#'   
#'   - \code{dropouts3}: The number of dropouts at the stage for 
#'   the control group.
#'   
#'   - \code{totalDropouts}: The total number of dropouts at the stage.
#'   
#'   - \code{logRankStatistic13}: The log-rank test Z-statistic 
#'   comparing the active treatment 1 to the control for the endpoint.
#'   
#'   - \code{logRankStatistic23}: The log-rank test Z-statistic 
#'   comparing the active treatment 2 to the control for the endpoint.
#'   
#'   - \code{logRankStatistic12}: The log-rank test Z-statistic 
#'   comparing the active treatment 1 to the active treatment 2 
#'   for the endpoint.
#'   
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer): A data frame for subject-level data for selected
#' replications, containing the following variables:
#' 
#'   - \code{iterationNumber}: The iteration number.
#'   
#'   - \code{stageNumber}: The stage under consideration.
#'   
#'   - \code{analysisTime}: The time for the stage since trial start.
#'   
#'   - \code{subjectId}: The subject ID.
#'   
#'   - \code{arrivalTime}: The enrollment time for the subject.
#'   
#'   - \code{stratum}: The stratum for the subject.
#'   
#'   - \code{treatmentGroup}: The treatment group (1, 2, or 3) for 
#'   the subject.
#'   
#'   - \code{survivalTime1}: The underlying survival time for 
#'   event endpoint 1 for the subject.
#'   
#'   - \code{dropoutTime1}: The underlying dropout time for 
#'   event endpoint 1 for the subject.
#'   
#'   - \code{timeUnderObservation1}: The time under observation since 
#'   since randomization for event endpoint 1 for the subject.
#'   
#'   - \code{event1}: Whether the subject experienced event endpoint 1.
#'   
#'   - \code{dropoutEvent1}: Whether the subject dropped out for 
#'   endpoint 1.
#'   
#'   - \code{survivalTime2}: The underlying survival time for 
#'   event endpoint 2 for the subject.
#'   
#'   - \code{dropoutTime2}: The underlying dropout time for 
#'   event endpoint 2 for the subject.
#'   
#'   - \code{timeUnderObservation2}: The time under observation since 
#'   since randomization for event endpoint 2 for the subject.
#'   
#'   - \code{event2}: Whether the subject experienced event endpoint 2.
#'   
#'   - \code{dropoutEvent2}: Whether the subject dropped out for 
#'   endpoint 2.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' 
#' sim1 = lrsim2e3a(
#'   kMax = 3, 
#'   kMaxe1 = 2,
#'   allocation1 = 2, 
#'   allocation2 = 2, 
#'   allocation3 = 1,
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   rho = 0,
#'   lambda1e1 = log(2)/12*0.60,
#'   lambda2e1 = log(2)/12*0.70,
#'   lambda3e1 = log(2)/12,
#'   lambda1e2 = log(2)/30*0.65, 
#'   lambda2e2 = log(2)/30*0.75,
#'   lambda3e2 = log(2)/30,
#'   accrualDuration = 30.143,
#'   plannedEvents = c(186, 259, 183),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'  
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#'  
#' @export
lrsim2e3a <- function(kMax = NA_integer_, kMaxe1 = NA_integer_, hazardRatioH013e1 = 1, hazardRatioH023e1 = 1, hazardRatioH012e1 = 1, hazardRatioH013e2 = 1, hazardRatioH023e2 = 1, hazardRatioH012e2 = 1, allocation1 = 1L, allocation2 = 1L, allocation3 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, rho = 0, lambda1e1 = NA_real_, lambda2e1 = NA_real_, lambda3e1 = NA_real_, lambda1e2 = NA_real_, lambda2e2 = NA_real_, lambda3e2 = NA_real_, gamma1e1 = 0L, gamma2e1 = 0L, gamma3e1 = 0L, gamma1e2 = 0L, gamma2e2 = 0L, gamma3e2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim2e3a`, kMax, kMaxe1, hazardRatioH013e1, hazardRatioH023e1, hazardRatioH012e1, hazardRatioH013e2, hazardRatioH023e2, hazardRatioH012e2, allocation1, allocation2, allocation3, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, rho, lambda1e1, lambda2e1, lambda3e1, lambda1e2, lambda2e2, lambda3e2, gamma1e1, gamma2e1, gamma3e1, gamma1e2, gamma2e2, gamma3e2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Number of enrolled subjects
#' @description Obtains the number of subjects enrolled by given calendar
#' times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of enrolled subjects.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_accrualDuration
#'
#' @return A vector of total number of subjects enrolled by the
#' specified calendar times.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' # Example 1: Uniform enrollment with 20 patients per month for 12 months.
#'
#' accrual(time = 3, accrualTime = 0, accrualIntensity = 20,
#'         accrualDuration = 12)
#'
#'
#' # Example 2: Piecewise accrual, 10 patients per month for the first
#' # 3 months, and 20 patients per month thereafter. Patient recruitment
#' # ends at 12 months for the study.
#'
#' accrual(time = c(2, 9), accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), accrualDuration = 12)
#'
#' @export
accrual <- function(time = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, accrualDuration = NA_real_) {
    .Call(`_lrstat_accrual`, time, accrualTime, accrualIntensity, accrualDuration)
}

#' @title Accrual duration to enroll target number of subjects
#' @description Obtains the accrual duration to enroll the target number 
#' of subjects.
#'
#' @param nsubjects The vector of target number of subjects.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#'
#' @return A vector of accrual durations.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' getAccrualDurationFromN(nsubjects = c(20, 150), accrualTime = c(0, 3),
#'                         accrualIntensity = c(10, 20))
#'
#' @export
getAccrualDurationFromN <- function(nsubjects = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_) {
    .Call(`_lrstat_getAccrualDurationFromN`, nsubjects, accrualTime, accrualIntensity)
}

#' @title Probability of being at risk
#' @description Obtains the probability of being at risk at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of being at risk.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of being at risk at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' patrisk(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'         lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
patrisk <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_patrisk`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Probability of having an event
#' @description Obtains the probability of having an event at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of having an event.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of having an event at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pevent(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'        lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pevent <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pevent`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval with constant hazard
#' @description Obtains the integration probability of having an event
#' during an interval with constant hazard.
#'
#' @param j The analysis time interval with constant hazard.
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval with constant hazard for a treatment
#' group with specified piecewise exponential survival and dropout
#' distributions.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' hd(j = 1, t1 = 1, t2 = 3, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
hd <- function(j = NA_integer_, t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_hd`, j, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval
#' @description Obtains the integration of the probability of having an event
#' during an interval. The specified analysis time interval can span more
#' than one analysis time interval with constant hazard.
#'
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval for a treatment group with specified
#' piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pd(t1 = 1, t2 = 8, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pd <- function(t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pd`, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of patients enrolled during an interval and having an event
#' by specified calendar times
#' @description Obtains the number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @param u1 Lower bound of the accrual time interval.
#' @param u2 Upper bound of the accrual time interval.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times for a given treatment group had the enrollment being
#' restricted to the treatment group. By definition, we must have
#' \code{time >= u2}.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, 10 patients per month for the first 3 months, and
#' # 20 patients per month thereafter. Piecewise exponential survival with
#' # hazard 0.0533 in the first 6 months, and hazard 0.0309 thereafter,
#' # and 5% dropout by the end of 1 year.
#'
#' ad(time = c(9, 15), u1 = 1, u2 = 8, accrualTime = c(0, 3),
#'    accrualIntensity = c(10, 20), piecewiseSurvivalTime=c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
ad <- function(time = NA_real_, u1 = NA_real_, u2 = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_ad`, time, u1, u2, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of subjects at risk
#' @description Obtains the number of subjects at risk at given analysis
#' times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients at risk.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients at risk at the specified
#' analysis times (row) for each treatment group (column).
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' natrisk(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
natrisk <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_natrisk`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event
#' @description Obtains the number of subjects having an event by given
#' analysis times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' analysis times (row) for each treatment group (column).
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' nevent(time = c(9, 24), allocationRatioPlanned = 1,
#'        accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'        piecewiseSurvivalTime = c(0, 6),
#'        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 12, minFollowupTime = 18,
#'        maxFollowupTime = 30)
#'
#' @export
nevent <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event by calendar time
#' @description Obtains the number of subjects having an event by given
#' calendar times for each treatment group.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' calendar times (row) for each treatment group (column).
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' nevent2(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
nevent2 <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent2`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event and log-rank statistic
#' for a hypothesized hazard ratio at a given calendar time
#'
#' @description Obtains the number of subjects having an event in each
#' treatment group by stratum, the mean and variance of weighted log-rank
#' score statistic for a hypothesized hazard ratio at a given calendar time.
#'
#' @param time The calendar time at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#'  Defaults to 0 for obtaining log-rank test score statistic mean
#'  and variance.
#'
#' @return A data frame of the following variables if 
#' \code{predictEventOnly = 1}:
#' 
#' * \code{stratum}: The stratum number.
#' 
#' * \code{time}: The analysis time since trial start.
#' 
#' * \code{subjects}: The number of enrolled subjects.
#' 
#' * \code{nevents}: The total number of events. 
#' 
#' * \code{nevents1}: The number of events in the active treatment group.
#' 
#' * \code{nevents2}: The number of events in the control group.
#' 
#' * \code{ndropouts}: The total number of dropouts.
#' 
#' * \code{ndropouts1}: The number of events for the active treatment group.
#' 
#' * \code{ndropouts2}: The number of events for the control group.
#' 
#' * \code{nfmax}: The total number of subjects reaching maximum follow-up.
#' 
#' * \code{nfmax1}: The number of subjects reaching maximum follow-up in 
#' the active treatment group. 
#' 
#' * \code{nfmax2}: The number of subjects reaching maximum follow-up in 
#' the control group. 
#' 
#' If \code{predictEventOnly = 0}, the following variables will also 
#' be included:
#' 
#' * \code{uscore}: The numerator of the weighted log-rank test statistic.
#' 
#' * \code{vscore}: The variance of the weighted log-rank score statistic 
#' with weight squared.
#' 
#' * \code{iscore}: The Fisher information of the weighted log-rank score 
#' statistic. 
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat1(time = 22, hazardRatioH0 = 1,
#'         allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat1 <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat1`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Number of subjects having an event and log-rank statistics
#' @description Obtains the number of subjects accrued, number of events,
#' number of dropouts, and number of subjects reaching the maximum 
#' follow-up in each group, mean and variance of weighted log-rank
#' score statistic, estimated hazard ratio from weighted Cox regression
#' and variance of log hazard ratio estimate at given calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictTarget The target of prediction. 
#' Set \code{predictTarget = 1} to predict the number of events only.
#' Set \code{predictTarget = 2} (default) to predict the umber of events 
#' and log-rank score statistic mean and variance.
#' Set \code{predictTarget = 3} to predict the number of events,
#' log-rank score statistic mean and variance, and
#' hazard ratio and variance of log hazard ratio.
#'
#' @return A data frame containing the following variables if 
#' \code{predictTarget = 1}: 
#' 
#' * \code{time}: The analysis time since trial start.
#' 
#' * \code{subjects}: The number of enrolled subjects.
#' 
#' * \code{nevents}: The total number of events. 
#' 
#' * \code{nevents1}: The number of events in the active treatment group.
#' 
#' * \code{nevents2}: The number of events in the control group.
#' 
#' * \code{ndropouts}: The total number of dropouts.
#' 
#' * \code{ndropouts1}: The number of events for the active treatment group.
#' 
#' * \code{ndropouts2}: The number of events for the control group.
#' 
#' * \code{nfmax}: The total number of subjects reaching maximum follow-up.
#' 
#' * \code{nfmax1}: The number of subjects reaching maximum follow-up in 
#' the active treatment group. 
#' 
#' * \code{nfmax2}: The number of subjects reaching maximum follow-up in 
#' the control group. 
#' 
#' If \code{predictTarget = 2}, the following variables will also 
#' be included:
#' 
#' * \code{uscore}: The numerator of the log-rank test statistic.
#' 
#' * \code{vscore}: The variance of the log-rank score test statistic.
#' 
#' * \code{logRankZ}: The log-rank test statistic on the Z-scale. 
#' 
#' * \code{hazardRatioH0}: The hazard ratio under the null hypothesis. 
#' 
#' Furthermore, if \code{predictTarget = 3}, the following additional 
#' variables will also be included:
#' 
#' * \code{HR}: The average hazard ratio from weighted Cox regression.
#' 
#' * \code{vlogHR}: The variance of log hazard ratio.
#' 
#' * \code{zlogHR}: The Z-statistic for log hazard ratio. 
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat(time = c(22, 40), allocationRatioPlanned = 1,
#'        accrualTime = seq(0, 9),
#'        accrualIntensity = c(26/9*seq(1, 9), 26),
#'        piecewiseSurvivalTime = c(0, 6),
#'        stratumFraction = c(0.2, 0.8),
#'        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'        gamma1 = -log(1-0.05)/12,
#'        gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 22,
#'        followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictTarget = 2L) {
    .Call(`_lrstat_lrstat`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictTarget)
}

#' @title Kaplan-Meier estimate of milestone survival
#' 
#' @description Obtains the Kaplan-Meier estimate of milestone survival 
#' probability and associated variance estimate using the Greenwood formula
#' by treatment group and by stratum at given analysis time.
#'
#' @param time The calendar time for data cut.  
#' @param milestone The milestone time at which to calculate the 
#'   Kaplan-Meier estimate of survival probability.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_numSubintervals
#'
#' @return A data frame containing the following variables: 
#' 
#' * \code{stratum}: The stratum.
#' 
#' * \code{time}: The calendar time since trial start.
#' 
#' * \code{subjects}: The enrolled number of subjects. 
#' 
#' * \code{milestone}: The milestone time relative to randomization. 
#' 
#' * \code{surv1}: The milestone survival probability for the treatment group.
#' 
#' * \code{surv2}: The milestone survival probability for the control group.
#' 
#' * \code{vsurv1}: The variance for \code{surv1}.
#' 
#' * \code{vsurv2}: The variance for \code{surv2}.
#' 
#' * \code{survdiff}: The difference in milestone survival probabilities, 
#' i.e., \code{surv1 - surv2}.
#' 
#' * \code{vsurvdiff}: The variance for \code{survdiff}.
#' 
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' kmest1(time = 40, 
#'        milestone = 18, 
#'        allocationRatioPlanned = 1,
#'        accrualTime = seq(0, 9),
#'        accrualIntensity = c(26/9*seq(1, 9), 26),
#'        piecewiseSurvivalTime = c(0, 6),
#'        stratumFraction = c(0.2, 0.8),
#'        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'        gamma1 = -log(1-0.05)/12,
#'        gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 22,
#'        followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
kmest1 <- function(time = NA_real_, milestone = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, numSubintervals = 300L) {
    .Call(`_lrstat_kmest1`, time, milestone, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, numSubintervals)
}

#' @title Stratified difference in milestone survival
#' @description Obtains the stratified Kaplan-Meier estimate of 
#'   milestone survival probabilities and difference in milestone 
#'   survival at given calendar times and milestone time.
#'
#' @param time A vector of calendar times at which to calculate the 
#'   milestone survival.
#' @param milestone The milestone time at which to calculate the 
#'   Kaplan-Meier estimate of survival probability.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_numSubintervals
#' 
#' @return A data frame containing the following variables: 
#' 
#' * \code{time}: The calendar time at which to calculate the milestone 
#' survival.
#' 
#' * \code{subjects}: The enrolled number of subjects. 
#' 
#' * \code{milestone}: The milestone time relative to randomization. 
#' 
#' * \code{surv1}: The milestone survival probability for the treatment group.
#' 
#' * \code{surv2}: The milestone survival probability for the control group.
#' 
#' * \code{vsurv1}: The variance for \code{surv1}.
#' 
#' * \code{vsurv2}: The variance for \code{surv2}.
#' 
#' * \code{survdiff}: The difference in milestone survival probabilities, 
#' i.e., \code{surv1 - surv2}.
#' 
#' * \code{vsurvdiff}: The variance for \code{survdiff}.
#' 
#' * \code{survdiffZ}: The Z-statistic value, i.e., 
#' \code{survdiff/sqrt(vsurvdiff)}.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' kmest(time = c(22, 40), 
#'       milestone = 18, 
#'       allocationRatioPlanned = 1,
#'       accrualTime = seq(0, 9),
#'       accrualIntensity = c(26/9*seq(1, 9), 26),
#'       piecewiseSurvivalTime = c(0, 6),
#'       stratumFraction = c(0.2, 0.8),
#'       lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'       lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'       gamma1 = -log(1-0.05)/12,
#'       gamma2 = -log(1-0.05)/12,
#'       accrualDuration = 22,
#'       followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
kmest <- function(time = NA_real_, milestone = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, numSubintervals = 300L) {
    .Call(`_lrstat_kmest`, time, milestone, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, numSubintervals)
}

#' @title Calendar times for target number of events
#' @description Obtains the calendar times to reach the target number of
#' subjects having an event.
#'
#' @param nevents A vector of target number of events.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#'
#' @return A vector of calendar times expected to yield the target
#' number of events.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' caltime(nevents = c(24, 80), allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
caltime <- function(nevents = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L) {
    .Call(`_lrstat_caltime`, nevents, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup)
}

#' @title Range of accrual duration for target number of events
#' @description Obtains a range of accrual duration to reach the 
#' target number of events.
#'
#' @param nevents The target number of events.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @param npoints The number of accrual duration time points. 
#'   Defaults to 23.
#' @param interval The interval to search for the solution of
#'   accrualDuration. Defaults to \code{c(0.001, 240)}.
#' 
#' @return A data frame of the following variables: 
#' 
#' * \code{nevents}: The target number of events.
#' 
#' * \code{fixedFollowup}: Whether a fixed follow-up design is used.
#' 
#' * \code{accrualDuration}: The accrual duration.
#' 
#' * \code{subjects}: The total number of subjects.
#' 
#' * \code{studyDuration}: The study duration. 
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' getDurationFromNevents(
#'   nevents = 80, allocationRatioPlanned = 1,
#'   accrualTime = seq(0, 8),
#'   accrualIntensity = 26/9*seq(1, 9),
#'   piecewiseSurvivalTime = c(0, 6),
#'   stratumFraction = c(0.2, 0.8),
#'   lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'   lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'   gamma1 = -log(1-0.05)/12,
#'   gamma2 = -log(1-0.05)/12,
#'   fixedFollowup = FALSE)
#'
#' @export
getDurationFromNevents <- function(nevents = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, followupTime = 18, fixedFollowup = 0L, npoints = 23L, interval = as.numeric( c(0.001, 240))) {
    .Call(`_lrstat_getDurationFromNevents`, nevents, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, followupTime, fixedFollowup, npoints, interval)
}

#' @title Log-rank test power
#' @description Estimates the power, stopping probabilities, and expected
#' sample size in a two-group survival design.
#'
#' @inheritParams param_kMax
#' @param informationRates The information rates in terms of number 
#'   of events for the conventional log-rank test and in terms of 
#'   the actual information for weighted log-rank tests. 
#'   Defaults to \code{(1:kMax) / kMax} if left unspecified.
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @param typeBetaSpending The type of beta spending. One of the following:
#'  "sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
#'  spending function, "sfKD" for Kim & DeMets spending function,
#'  "sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
#'  early futility stopping. Defaults to "none".
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#' @param studyDuration Study duration for fixed follow-up design. 
#'   Defaults to missing, which is to be replaced with the sum of 
#'   \code{accrualDuration} and \code{followupTime}. If provided, 
#'   the value is allowed to be less than the sum of \code{accrualDuration} 
#'   and \code{followupTime}.
#' 
#'   
#' @return An S3 class \code{lrpower} object with 4 components:
#'
#'* \code{overallResults}: A data frame containing the following variables: 
#'
#'   - \code{overallReject}: The overall rejection probability.
#'   
#'   - \code{alpha}: The overall significance level.
#'   
#'   - \code{numberOfEvents}: The total number of events. 
#'   
#'   - \code{numberOfDropouts}: The total number of dropouts. 
#'   
#'   - \code{numbeOfSubjects}: The total number of subjects.
#'   
#'   - \code{studyDuration}: The total study duration. 
#'   
#'   - \code{expectedNumberOfEvents}: The expected number of events.
#'   
#'   - \code{expectedNumberOfDropouts}: The expected number of dropouts. 
#'   
#'   - \code{expectedNumberOfSubjects}: The expected number of subjects.
#'   
#'   - \code{expectedStudyDuration}: The expected study duration.
#'   
#'   - \code{accrualDuration}: The accrual duration.
#'   
#'   - \code{followupTime}: The follow-up duration. 
#'   
#'   - \code{fixedFollowup}: Whether a fixed follow-up design is used.
#'   
#'   - \code{rho1}: The first parameter of the Fleming-Harrington family 
#'   of weighted log-rank test.
#'   
#'   - \code{rho2}: The second parameter of the Fleming-Harrington family 
#'   of weighted log-rank test.
#'   
#'   - \code{allocationRatioPlanned}: Allocation ratio for the active 
#'   treatment versus control. 
#'   
#'   - \code{kMax}: The number of stages.
#'   
#'   - \code{hazardRatioH0}: The hazard ratio under the null hypothesis.
#'   
#'   - \code{etimateHazardRatio}: Whether to estimate the hazard ratio.
#'   
#'   - \code{typeOfComputation}: The type of computation, 
#'   either "direct" for the direct approximation method, 
#'   or "schoenfeld" for the Schoenfeld method.
#'
#' * \code{byStageResults}: A data frame containing the following variables:
#' 
#'   - \code{informationRates}: The information rates.
#'   
#'   - \code{efficacyBounds}: The efficacy boundaries on the Z-scale.
#'   
#'   - \code{futilityBounds}: The futility boundaries on the Z-scale.
#'   
#'   - \code{rejectPerStage}: The probability for efficacy stopping.
#'   
#'   - \code{futilityPerStage}: The probability for futility stopping.
#'   
#'   - \code{cumulativeRejection}: The cumulative probability for efficacy 
#'   stopping.
#'   
#'   - \code{cumulativeFutility}: The cumulative probability for futility 
#'   stopping.
#'   
#'   - \code{cumulativeAlphaSpent}: The cumulative alpha spent.
#'   
#'   - \code{numberOfEvents}: The number of events.
#'   
#'   - \code{numberOfDropouts}: The number of dropouts.
#'   
#'   - \code{numberOfSubjects}: The number of subjects.
#'   
#'   - \code{analysisTime}: The average time since trial start.
#'   
#'   - \code{efficacyHR}: The efficacy boundaries on the hazard ratio scale.
#'   
#'   - \code{futilityHR}: The futility boundaries on the hazard ratio scale.
#'   
#'   - \code{efficacyP}: The efficacy boundaries on the p-value scale.
#'   
#'   - \code{futilityP}: The futility boundaries on the p-value scale.
#'   
#'   - \code{information}: The cumulative information.
#'   
#'   - \code{HR}: The average hazard ratio. 
#'   
#'   - \code{efficacyStopping}: Whether to allow efficacy stopping.
#'   
#'   - \code{futilityStopping}: Whether to allow futility stopping.
#'
#' * \code{settings}: A list containing the following input parameters: 
#'   \code{typeAlphaSpending}, \code{parameterAlphaSpending},
#'   \code{userAlphaSpending}, \code{typeBetaSpending},
#'   \code{parameterBetaSpending}, \code{userBetaSpending},
#'   \code{accrualTime}, \code{accuralIntensity},
#'   \code{piecewiseSurvivalTime}, \code{stratumFraction},
#'   \code{lambda1}, \code{lambda2}, \code{gamma1}, \code{gamma2}, and
#'   \code{spendingTime}.
#'
#' * \code{byTreatmentCounts}: A list containing the following counts by 
#' treatment group:
#' 
#'   - \code{numberOfEvents1}: The number of events by stage for 
#'   the treatment group.
#'   
#'   - \code{numberOfDropouts1}: The number of dropouts by stage for 
#'   the treatment group.
#'   
#'   - \code{numberOfSubjects1}: The number of subjects by stage for 
#'   the treatment group.
#'   
#'   - \code{numberOfEvents2}: The number of events by stage for 
#'   the control group.
#'   
#'   - \code{numberOfDropouts2}: The number of dropouts by stage for 
#'   the control group.
#'   
#'   - \code{numberOfSubjects2}: The number of subjects by stage for 
#'   the control group.   
#'   
#'   - \code{expectedNumberOfEvents1}: The expected number of events for 
#'   the treatment group.
#'   
#'   - \code{expectedNumberOfDropouts1}: The expected number of dropouts for 
#'   the treatment group.
#'   
#'   - \code{expectedNumberOfSubjects1}: The expected number of subjects for 
#'   the treatment group.
#'   
#'   - \code{expectedNumberOfEvents2}: The expected number of events for 
#'   control group.
#'   
#'   - \code{expectedNumberOfDropouts2}: The expected number of dropouts for 
#'   the control group.
#'   
#'   - \code{expectedNumberOfSubjects2}: The expected number of subjects for 
#'   the control group.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @examples
#' # Piecewise accrual, piecewise exponential survival, and 5% dropout by
#' # the end of 1 year.
#'
#' lrpower(kMax = 2, informationRates = c(0.8, 1),
#'         alpha = 0.025, typeAlphaSpending = "sfOF",
#'         allocationRatioPlanned = 1, accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12, accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrpower <- function(kMax = 1L, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct", spendingTime = NA_real_, studyDuration = NA_real_) {
    .Call(`_lrstat_lrpower`, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation, spendingTime, studyDuration)
}

#' @title Get group sequential design
#' @description Obtains the maximum information and stopping boundaries 
#' for a generic group sequential design assuming a constant treatment 
#' effect, or obtains the power given the maximum information and 
#' stopping boundaries.
#'
#' @param beta The type II error.
#' @param IMax The maximum information. Either \code{beta} or \code{IMax} 
#' should be provided while the other one should be missing.
#' @param theta The parameter value.
#' @inheritParams param_kMax
#' @param informationRates The information rates. Fixed prior to the trial. 
#'   Defaults to \code{(1:kMax) / kMax} if left unspecified.
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#'
#' @return An S3 class \code{design} object with three components:
#' 
#' * \code{overallResults}: A data frame containing the following variables:
#' 
#'   - \code{overallReject}: The overall rejection probability.
#'   
#'   - \code{alpha}: The overall significance level.
#'   
#'   - \code{kMax}: The number of stages.
#'   
#'   - \code{theta}: The parameter value.
#'   
#'   - \code{maxInformation}: The maximum information.
#'   
#'   - \code{expectedInformationH1}: The expected information under H1.
#'   
#'   - \code{expectedInformationH0}: The expected information under H0.
#'   
#'   - \code{drift}: The drift parameter, equal to 
#'   \code{theta*sqrt(maxInformation)}.
#'   
#'   - \code{inflationFactor}: The inflation factor (relative to the 
#'   fixed design).
#'
#' * \code{byStageResults}: A data frame containing the following variables:
#' 
#'   - \code{informationRates}: The information rates.
#'   
#'   - \code{efficacyBounds}: The efficacy boundaries on the Z-scale.
#'   
#'   - \code{futilityBounds}: The futility boundaries on the Z-scale.
#'   
#'   - \code{rejectPerStage}: The probability for efficacy stopping.
#'   
#'   - \code{futilityPerStage}: The probability for futility stopping.
#'   
#'   - \code{cumulativeRejection}: The cumulative probability for efficacy 
#'   stopping.
#'   
#'   - \code{cumulativeFutility}: The cumulative probability for futility 
#'   stopping.
#'   
#'   - \code{cumulativeAlphaSpent}: The cumulative alpha spent.
#'   
#'   - \code{efficacyTheta}: The efficacy boundaries on the parameter scale.
#'   
#'   - \code{futilityTheta}: The futility boundaries on the parameter scale.
#'   
#'   - \code{efficacyP}: The efficacy boundaries on the p-value scale.
#'   
#'   - \code{futilityP}: The futility boundaries on the p-value scale.
#'   
#'   - \code{information}: The cumulative information.
#'   
#'   - \code{efficacyStopping}: Whether to allow efficacy stopping.
#'   
#'   - \code{futilityStopping}: Whether to allow futility stopping.
#'
#' * \code{settings}: A list containing the following input parameters: 
#' 
#'   - \code{typeAlphaSpending}: The type of alpha spending. 
#'   
#'   - \code{parameterAlphaSpending}: The parameter value for alpha spending.
#'   
#'   - \code{userAlphaSpending}: The user defined alpha spending. 
#'   
#'   - \code{typeBetaSpending}: The type of beta spending. 
#'   
#'   - \code{parameterBetaSpending}: The parameter value for beta spending. 
#'   
#'   - \code{userBetaSpending}: The user defined beta spending.
#'   
#'   - \code{spendingTime}: The error spending time at each analysis. 
#'   
#'   - \code{calculationTarget}: The calculation target, \code{beta} or 
#'   \code{IMax}.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references 
#' Christopher Jennison, Bruce W. Turnbull. Group Sequential Methods with
#' Applications to Clinical Trials. Chapman & Hall/CRC: Boca Raton, 2000,
#' ISBN:0849303168
#'
#' @examples
#'
#' # Example 1: obtain the maximum information given power
#' getDesign(beta = 0.2, theta = -log(0.7),
#'           kMax = 2, informationRates = c(0.5,1),
#'           alpha = 0.025, typeAlphaSpending = "sfOF",
#'           typeBetaSpending = "sfP")
#'           
#' 
#' # Example 2: obtain power given the maximum information
#' getDesign(IMax = 72.5, theta = -log(0.7),
#'           kMax = 3, informationRates = c(0.5, 0.75, 1),
#'           alpha = 0.025, typeAlphaSpending = "sfOF",
#'           typeBetaSpending = "sfP")
#'
#' @export
getDesign <- function(beta = NA_real_, IMax = NA_real_, theta = NA_real_, kMax = 1L, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_getDesign`, beta, IMax, theta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, spendingTime)
}

#' @title Adaptive design at an interim look
#' @description Obtains the conditional power for specified incremental 
#' information given the interim results, parameter value, and data-dependent 
#' changes in the error spending function and the number and spacing of 
#' interim looks. Conversely, obtain the incremental information needed 
#' to attain a specified conditional power given the interim results,
#' parameter value, and data-dependent changes in the error spending 
#' function and the number and spacing of interim looks.
#'
#' @param betaNew The type II error for the secondary trial.
#' @param INew The maximum information of the secondary trial. Either 
#' \code{betaNew} or \code{INew} should be provided while the other one 
#' should be missing.
#' @param L The interim adaptation look of the primary trial.
#' @param zL The z-test statistic at the interim adaptation look of 
#'   the primary trial.
#' @param theta The parameter value.
#' @param IMax The maximum information of the primary trial. Must be 
#'   provided if \code{futilityBounds} is missing and 
#'   \code{typeBetaSpending} is not equal to "none".
#' @param kMax The maximum number of stages of the primary trial.
#' @param informationRates The information rates of the primary trial.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param futilityStopping Indicators of whether futility stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping for the primary trial.
#' @param alpha The significance level of the primary trial. 
#'   Defaults to 0.025.
#' @param typeAlphaSpending The type of alpha spending for the primary 
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, 
#'   "user" for user defined spending, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending
#'   for the primary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param userAlphaSpending The user defined alpha spending for the primary 
#'   trial. Cumulative alpha spent up to each stage.
#' @param futilityBounds The lower boundaries on the z-test statistic scale 
#'   for futility stopping for the primary trial. Defaults to 
#'   \code{rep(-6, kMax-1)} if left unspecified.
#' @param typeBetaSpending The type of beta spending for the primary trial. 
#'   One of the following: 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and
#'   "none" for no early futility stopping. 
#'   Defaults to "none".
#' @param parameterBetaSpending The parameter value of beta spending 
#'   for the primary trial. Corresponds to rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param spendingTime The error spending time of the primary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#' @param MullerSchafer Whether to use the Muller and Schafer (2001) method 
#'   for trial adaptation.
#' @param kNew The number of looks of the secondary trial.
#' @param informationRatesNew The spacing of looks of the secondary trial.
#' @param efficacyStoppingNew The indicators of whether efficacy stopping is 
#'   allowed at each look of the secondary trial. Defaults to true 
#'   if left unspecified.
#' @param futilityStoppingNew The indicators of whether futility stopping is 
#'   allowed at each look of the secondary trial. Defaults to true 
#'   if left unspecified.
#' @param typeAlphaSpendingNew The type of alpha spending for the secondary
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpendingNew The parameter value of alpha spending 
#'   for the secondary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param typeBetaSpendingNew The type of beta spending for the secondary
#'   trial. One of the following: 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, 
#'   "user" for user defined spending, and 
#'   "none" for no early futility stopping. 
#'   Defaults to "none".
#' @param parameterBetaSpendingNew The parameter value of beta spending 
#'   for the secondary trial. Corresponds to rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param userBetaSpendingNew The user defined cumulative beta spending. 
#'   Cumulative beta spent up to each stage of the secondary trial.
#' @param spendingTimeNew The error spending time of the secondary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRatesNew}.
#'
#' @return An \code{adaptDesign} object with two list components: 
#' 
#' * \code{primaryTrial}: A list of selected information for the primary 
#' trial, including \code{L}, \code{zL}, \code{theta}, \code{kMax}, 
#' \code{informationRates}, \code{efficacyBounds}, \code{futilityBounds},
#' and \code{MullerSchafer}.
#'  
#' * \code{secondaryTrial}: A \code{design} object for the secondary trial.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @references 
#' Lu Chi, H. M. James Hung, and Sue-Jane Wang. 
#' Modification of sample size in group sequential clinical trials.
#' Biometrics 1999;55:853-857.
#' 
#' Hans-Helge Muller and Helmut Schafer. 
#' Adaptive group sequential designs for clinical trials:
#' Combining the advantages of adaptive and of
#' classical group sequential approaches. 
#' Biometrics 2001;57:886-891.
#' 
#' @seealso \code{\link{getDesign}}
#' 
#' @examples
#'
#' # original group sequential design with 90% power to detect delta = 6
#' delta = 6
#' sigma = 17
#' n = 282
#' (des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
#'                   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'                   parameterAlphaSpending = -4))
#' 
#' # interim look results
#' L = 1
#' n1 = n/3
#' delta1 = 4.5
#' sigma1 = 20
#' zL = delta1/sqrt(4/n1*sigma1^2)
#' 
#' t = des1$byStageResults$informationRates
#' 
#' # conditional power with sample size increase
#' (des2 = adaptDesign(
#'   betaNew = NA, INew = 420/(4*sigma1^2), 
#'   L, zL, theta = delta1, 
#'   IMax = n/(4*sigma1^2), kMax = 3, informationRates = t,
#'   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'   parameterAlphaSpending = -4))
#' 
#' # Muller & Schafer (2001) method to design the secondary trial: 
#' # 3-look gamma(-2) spending with 84% power at delta = 4.5 and sigma = 20
#' (des2 = adaptDesign(
#'   betaNew = 0.16, INew = NA, 
#'   L, zL, theta = delta1,
#'   IMax = n/(4*sigma1^2), kMax = 3, informationRates = t,
#'   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'   parameterAlphaSpending = -4,
#'   MullerSchafer = TRUE,
#'   kNew = 3, typeAlphaSpendingNew = "sfHSD", 
#'   parameterAlphaSpendingNew = -2))
#'   
#' # incremental sample size for sigma = 20
#' (nNew = 4*sigma1^2*des2$secondaryTrial$overallResults$maxInformation)
#'
#' @export
adaptDesign <- function(betaNew = NA_real_, INew = NA_real_, L = NA_integer_, zL = NA_real_, theta = NA_real_, IMax = NA_real_, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, spendingTime = NA_real_, MullerSchafer = 0L, kNew = NA_integer_, informationRatesNew = NA_real_, efficacyStoppingNew = NA_integer_, futilityStoppingNew = NA_integer_, typeAlphaSpendingNew = "sfOF", parameterAlphaSpendingNew = NA_real_, typeBetaSpendingNew = "none", parameterBetaSpendingNew = NA_real_, userBetaSpendingNew = NA_real_, spendingTimeNew = NA_real_) {
    .Call(`_lrstat_adaptDesign`, betaNew, INew, L, zL, theta, IMax, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, spendingTime, MullerSchafer, kNew, informationRatesNew, efficacyStoppingNew, futilityStoppingNew, typeAlphaSpendingNew, parameterAlphaSpendingNew, typeBetaSpendingNew, parameterBetaSpendingNew, userBetaSpendingNew, spendingTimeNew)
}

#' @title Get the required number of events from hazard ratios
#' @description Obtains the required number of events given the hazard 
#' ratios under the null and alternative hypotheses for a group 
#' sequential design.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#' @inheritParams param_hazardRatioH0
#' @param hazardRatio Hazard ratio under the alternative hypothesis 
#'   for the active treatment versus control. Defaults to 0.5.
#' @inheritParams param_allocationRatioPlanned
#' @param rounding Whether to round up the number of events. 
#'   Defaults to 1 for rounding.
#'
#' @return The required number of events.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#'
#' getNeventsFromHazardRatio(
#'   beta = 0.2, kMax = 2, 
#'   informationRates = c(0.5,1), 
#'   alpha = 0.025, typeAlphaSpending = "sfOF",
#'   typeBetaSpending = "sfP", 
#'   hazardRatio = 0.673)
#' 
#' @export
getNeventsFromHazardRatio <- function(beta = 0.2, kMax = 1L, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, spendingTime = NA_real_, hazardRatioH0 = 1, hazardRatio = 0.5, allocationRatioPlanned = 1, rounding = 1L) {
    .Call(`_lrstat_getNeventsFromHazardRatio`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, spendingTime, hazardRatioH0, hazardRatio, allocationRatioPlanned, rounding)
}

#' @title Log-rank test sample size
#' @description Obtains the needed accrual duration given power and
#' follow-up time, the needed follow-up time given power and
#' accrual duration, or the needed absolute accrual rates given
#' power, accrual duration, follow-up duration, and relative accrual
#' rates in a two-group survival design.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @param informationRates The information rates in terms of number 
#'   of events for the conventional log-rank test and in terms of 
#'   the actual information for weighted log-rank tests. 
#'   Defaults to \code{(1:kMax) / kMax} if left unspecified.
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' @param interval The interval to search for the solution of
#' accrualDuration, followupDuration, or the proportionality constant 
#' of accrualIntensity. Defaults to \code{c(0.001, 240)}.
#' Adjustment may be needed for non-monotone relationship with study power.
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#' @param rounding Whether to round up sample size and events. 
#'   Defaults to 1 for sample size rounding.
#' 
#' @return A list of two components: 
#' 
#' * \code{resultsUnderH1}: An S3 class \code{lrpower} object under the 
#' alternative hypothesis.
#' 
#' * \code{resultsUnderH0}: An S3 class \code{lrpower} object under the 
#' null hypothesis.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @seealso \code{\link{lrpower}}
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survival, and 5% dropout by
#' # the end of 1 year.
#'
#' # Example 1: Obtains accrual duration given power and follow-up duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = NA,
#'              followupTime = 18, fixedFollowup = FALSE)
#'
#'
#' # Example 2: Obtains follow-up duration given power and accrual duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = NA, fixedFollowup = FALSE)
#'
#'
#' # Example 3: Obtains absolute accrual intensity given power,
#' # accrual duration, follow-up duration, and relative accrual intensity
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrsamplesize <- function(beta = 0.2, kMax = 1L, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct", interval = as.numeric( c(0.001, 240)), spendingTime = NA_real_, rounding = 1L) {
    .Call(`_lrstat_lrsamplesize`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation, interval, spendingTime, rounding)
}

#' @title Update graph for graphical approaches
#' @description Updates the weights and transition matrix for graphical 
#' approaches.
#'
#' @param w The current vector of weights for elementary hypotheses.
#' @param G The current transition matrix.
#' @param I The set of indices for yet to be rejected hypotheses.
#' @param j The hypothesis to remove from index set \code{I}.
#'
#' @return A list containing the new vector of weights and the new 
#' transition matrix for the graph, and the new set of indices of yet 
#' to be rejected hypotheses.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' updateGraph(w = c(0.5, 0.5, 0, 0), 
#'             G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,  
#'                          0, 1, 0, 0,  1, 0, 0, 0), 
#'                        nrow=4, ncol=4, byrow=TRUE), 
#'             I = c(1, 2, 3, 4), 
#'             j = 1)
#'
#' @export
updateGraph <- function(w, G, I, j) {
    .Call(`_lrstat_updateGraph`, w, G, I, j)
}

fadjpboncpp <- function(w, G, p) {
    .Call(`_lrstat_fadjpboncpp`, w, G, p)
}

#' @title Weight matrix for all intersection hypotheses
#' @description Obtains the weight matrix for all intersection hypotheses.
#'
#' @param w The vector of weights for elementary hypotheses.
#' @param G The transition matrix.
#'
#' @return The weight matrix starting with the global null hypothesis.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#'
#' w = c(0.5,0.5,0,0)
#' g = matrix(c(0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,0), nrow=4, ncol=4, byrow=TRUE)
#' (wgtmat = fwgtmat(w,g))
#'
#' @export
fwgtmat <- function(w, G) {
    .Call(`_lrstat_fwgtmat`, w, G)
}

fadjpsimcpp <- function(wgtmat, p, family) {
    .Call(`_lrstat_fadjpsimcpp`, wgtmat, p, family)
}

repeatedPValuecpp <- function(kMax = NA_integer_, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, maxInformation = 1, p = NA_real_, information = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_repeatedPValuecpp`, kMax, typeAlphaSpending, parameterAlphaSpending, maxInformation, p, information, spendingTime)
}

fseqboncpp <- function(w, G, alpha = 0.025, kMax = NA_integer_, typeAlphaSpending = NA_character_, parameterAlphaSpending = NA_real_, incidenceMatrix = NA_integer_, maxInformation = NA_real_, p = NA_real_, information = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_fseqboncpp`, w, G, alpha, kMax, typeAlphaSpending, parameterAlphaSpending, incidenceMatrix, maxInformation, p, information, spendingTime)
}

fstp2seqcpp <- function(p, gamma, test = "hochberg", retest = 1L) {
    .Call(`_lrstat_fstp2seqcpp`, p, gamma, test, retest)
}

fstdmixcpp <- function(p, family, serial, parallel, gamma, test = "hommel", exhaust = 1L) {
    .Call(`_lrstat_fstdmixcpp`, p, family, serial, parallel, gamma, test, exhaust)
}

fmodmixcpp <- function(p, family, serial, parallel, gamma, test = "hommel", exhaust = 1L) {
    .Call(`_lrstat_fmodmixcpp`, p, family, serial, parallel, gamma, test, exhaust)
}

#' @title Confidence interval after trial termination
#' @description Obtains the p-value, median unbiased point estimate, and 
#' confidence interval after the end of a group sequential trial.
#'
#' @param L The termination look.
#' @param zL The z-test statistic at the termination look.
#' @param IMax The maximum information of the trial.
#' @param informationRates The information rates up to look \code{L}.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage up to look \code{L}. 
#'   Defaults to true if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping up to look \code{L}.
#' @inheritParams param_alpha
#' @param typeAlphaSpending The type of alpha spending. 
#'   One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending. 
#'   Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".
#' @param spendingTime The error spending time up to look \code{L}. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#'
#' @return A list with the following components: 
#' 
#' * \code{pvalue}: p-value for rejecting the null hypothesis.
#'  
#' * \code{thetahat}: Median unbiased point estimate of the parameter.
#' 
#' * \code{cilevel}: Confidence interval level.
#' 
#' * \code{lower}: Lower bound of confidence interval.
#' 
#' * \code{upper}: Upper bound of confidence interval.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references 
#' Anastasios A. Tsiatis, Gary L. Rosner and Cyrus R. Mehta. 
#' Exact confidence intervals following a group sequential test. 
#' Biometrics 1984;40:797-803.
#' 
#' @examples
#'
#' # group sequential design with 90% power to detect delta = 6
#' delta = 6
#' sigma = 17
#' n = 282
#' (des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
#'                   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'                   parameterAlphaSpending = -4))
#' 
#' # crossed the boundary at the second look
#' L = 2
#' n1 = n*2/3
#' delta1 = 7
#' sigma1 = 20
#' zL = delta1/sqrt(4/n1*sigma1^2)
#' 
#' # confidence interval
#' getCI(L = L, zL = zL, IMax = n/(4*sigma1^2), 
#'       informationRates = c(1/3, 2/3), alpha = 0.05, 
#'       typeAlphaSpending = "sfHSD", parameterAlphaSpending = -4)
#' 
#' @export
getCI <- function(L = NA_integer_, zL = NA_real_, IMax = NA_real_, informationRates = NA_real_, efficacyStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_getCI`, L, zL, IMax, informationRates, efficacyStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, spendingTime)
}

#' @title Repeated confidence interval for group sequential design
#' @description Obtains the repeated confidence interval 
#' for a group sequential trial.
#'
#' @param L The look of interest.
#' @param zL The z-test statistic at the look.
#' @param IMax The maximum information of the trial.
#' @param informationRates The information rates up to look \code{L}.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage up to look \code{L}. Defaults to true 
#'   if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping up to look \code{L}.
#' @inheritParams param_alpha
#' @param typeAlphaSpending The type of alpha spending. 
#'   One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending. 
#'   Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".
#' @param spendingTime The error spending time up to look \code{L}. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#'
#' @return A list with the following components: 
#' 
#' * \code{pvalue}: Repeated p-value for rejecting the null hypothesis.
#'  
#' * \code{thetahat}: Point estimate of the parameter.
#' 
#' * \code{cilevel}: Confidence interval level.
#' 
#' * \code{lower}: Lower bound of repeated confidence interval.
#' 
#' * \code{upper}: Upper bound of repeated confidence interval.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references 
#' Christopher Jennison and Bruce W. Turnbull. 
#' Interim analyses: the repeated confidence interval approach 
#' (with discussion). 
#' J R Stat Soc Series B. 1989;51:305-361.
#' 
#' @examples
#'
#' # group sequential design with 90% power to detect delta = 6
#' delta = 6
#' sigma = 17
#' n = 282
#' (des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
#'                   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'                   parameterAlphaSpending = -4))
#' 
#' # results at the second look
#' L = 2
#' n1 = n*2/3
#' delta1 = 7
#' sigma1 = 20
#' zL = delta1/sqrt(4/n1*sigma1^2)
#' 
#' # repeated confidence interval
#' getRCI(L = L, zL = zL, IMax = n/(4*sigma1^2), 
#'        informationRates = c(1/3, 2/3), alpha = 0.05, 
#'        typeAlphaSpending = "sfHSD", parameterAlphaSpending = -4)
#' 
#' @export
getRCI <- function(L = NA_integer_, zL = NA_real_, IMax = NA_real_, informationRates = NA_real_, efficacyStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_getRCI`, L, zL, IMax, informationRates, efficacyStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, spendingTime)
}

#' @title Confidence interval after adaptation
#' @description Obtains the p-value, median unbiased point estimate, and 
#' confidence interval after the end of an adaptive trial.
#'
#' @param L The interim adaptation look of the primary trial.
#' @param zL The z-test statistic at the interim adaptation look of 
#'   the primary trial.
#' @param IMax The maximum information of the primary trial.
#' @param kMax The maximum number of stages of the primary trial.
#' @param informationRates The information rates of the primary trial.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping for the primary trial.
#' @param alpha The significance level of the primary trial. 
#'   Defaults to 0.025.
#' @param typeAlphaSpending The type of alpha spending for the primary trial. 
#'   One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending 
#'   for the primary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param spendingTime The error spending time of the primary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#' @param L2 The termination look of the secondary trial.
#' @param zL2 The z-test statistic at the termination look of the 
#'   secondary trial.
#' @param INew The maximum information of the secondary trial.
#' @param MullerSchafer Whether to use the Muller and Schafer (2001) method 
#'   for trial adaptation.
#' @param informationRatesNew The spacing of looks of the secondary trial
#'   up to look \code{L2}.
#' @param efficacyStoppingNew The indicators of whether efficacy stopping is 
#'   allowed at each look of the secondary trial up to look \code{L2}. 
#'   Defaults to true if left unspecified.
#' @param typeAlphaSpendingNew The type of alpha spending for the secondary 
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpendingNew The parameter value of alpha spending 
#'   for the secondary trial. Corresponds to Delta for "WT", 
#'   rho for "sfKD", and gamma for "sfHSD".
#' @param spendingTimeNew The error spending time of the secondary trial
#'   up to look \code{L2}. Defaults to missing, in which case, it is 
#'   the same as \code{informationRatesNew}.
#' 
#' @return A list with the following components: 
#' 
#' * \code{pvalue}: p-value for rejecting the null hypothesis.
#'  
#' * \code{thetahat}: Median unbiased point estimate of the parameter.
#' 
#' * \code{cilevel}: Confidence interval level.
#' 
#' * \code{lower}: Lower bound of confidence interval.
#' 
#' * \code{upper}: Upper bound of confidence interval.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references
#' Ping Gao, Lingyun Liu and Cyrus Mehta. 
#' Exact inference for adaptive group sequential designs. 
#' Stat Med. 2013;32(23):3991-4005.
#'
#' @seealso \code{\link{adaptDesign}}
#' 
#' @examples
#'
#' # original group sequential design with 90% power to detect delta = 6
#' delta = 6
#' sigma = 17
#' n = 282
#' (des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
#'                   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'                   parameterAlphaSpending = -4))
#' 
#' # interim look results
#' L = 1
#' n1 = n/3
#' delta1 = 4.5
#' sigma1 = 20
#' zL = delta1/sqrt(4/n1*sigma1^2)
#' 
#' t = des1$byStageResults$informationRates
#' 
#' # Muller & Schafer (2001) method to design the secondary trial: 
#' des2 = adaptDesign(
#'   betaNew = 0.2, L = L, zL = zL, theta = 5,
#'   kMax = 3, informationRates = t,
#'   alpha = 0.05, typeAlphaSpending = "sfHSD",
#'   parameterAlphaSpending = -4,
#'   MullerSchafer = TRUE,
#'   kNew = 3, typeAlphaSpendingNew = "sfHSD", 
#'   parameterAlphaSpendingNew = -2)
#' 
#' n2 = ceiling(des2$secondaryTrial$overallResults$maxInformation*4*20^2)
#' ns = round(n2*(1:3)/3)
#'  (des2 = adaptDesign(
#'    INew = n2/(4*20^2), L = L, zL = zL, theta = 5,
#'    kMax = 3, informationRates = t,
#'    alpha = 0.05, typeAlphaSpending = "sfHSD",
#'    parameterAlphaSpending = -4,
#'    MullerSchafer = TRUE,
#'    kNew = 3, informationRatesNew = ns/n2,
#'    typeAlphaSpendingNew = "sfHSD",
#'    parameterAlphaSpendingNew = -2))
#' 
#' # termination at the second look of the secondary trial
#' L2 = 2
#' delta2 = 6.86
#' sigma2 = 21.77
#' zL2 = delta2/sqrt(4/197*sigma2^2)
#' 
#' t2 = des2$secondaryTrial$byStageResults$informationRates[1:L2]
#' 
#' # confidence interval
#' getADCI(L = L, zL = zL,
#'         IMax = n/(4*sigma1^2), kMax = 3,
#'         informationRates = t,
#'         alpha = 0.05, typeAlphaSpending = "sfHSD",
#'         parameterAlphaSpending = -4,
#'         L2 = L2, zL2 = zL2,
#'         INew = n2/(4*sigma2^2),
#'         MullerSchafer = TRUE,
#'         informationRatesNew = t2, 
#'         typeAlphaSpendingNew = "sfHSD",
#'         parameterAlphaSpendingNew = -2)
#' 
#' @export
getADCI <- function(L = NA_integer_, zL = NA_real_, IMax = NA_real_, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.25, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, spendingTime = NA_real_, L2 = NA_integer_, zL2 = NA_real_, INew = NA_real_, MullerSchafer = 0L, informationRatesNew = NA_real_, efficacyStoppingNew = NA_integer_, typeAlphaSpendingNew = "sfOF", parameterAlphaSpendingNew = NA_real_, spendingTimeNew = NA_real_) {
    .Call(`_lrstat_getADCI`, L, zL, IMax, kMax, informationRates, efficacyStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, spendingTime, L2, zL2, INew, MullerSchafer, informationRatesNew, efficacyStoppingNew, typeAlphaSpendingNew, parameterAlphaSpendingNew, spendingTimeNew)
}

#' @title Repeated confidence interval after adaptation
#' @description Obtains the repeated p-value, conservative point estimate, 
#' and repeated confidence interval for an adaptive group sequential trial.
#' 
#' @param L The interim adaptation look of the primary trial.
#' @param zL The z-test statistic at the interim adaptation look of 
#'   the primary trial.
#' @param IMax The maximum information of the primary trial.
#' @param kMax The maximum number of stages of the primary trial.
#' @param informationRates The information rates of the primary trial.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping for the primary trial.
#' @param alpha The significance level of the primary trial. 
#'   Defaults to 0.025.
#' @param typeAlphaSpending The type of alpha spending for the primary trial. 
#'   One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending 
#'   for the primary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param spendingTime The error spending time of the primary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#' @param L2 The look of interest in the secondary trial.
#' @param zL2 The z-test statistic at the look of the secondary trial.
#' @param INew The maximum information of the secondary trial.
#' @param MullerSchafer Whether to use the Muller and Schafer (2001) method 
#'   for trial adaptation.
#' @param informationRatesNew The spacing of looks of the secondary trial.
#' @param efficacyStoppingNew The indicators of whether efficacy stopping is 
#'   allowed at each look of the secondary trial up to look \code{L2}. 
#'   Defaults to true if left unspecified.
#' @param typeAlphaSpendingNew The type of alpha spending for the secondary 
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpendingNew The parameter value of alpha spending 
#'   for the secondary trial. Corresponds to Delta for "WT", 
#'   rho for "sfKD", and gamma for "sfHSD".
#' @param spendingTimeNew The error spending time of the secondary trial. 
#'   up to look \code{L2}. Defaults to missing, in which case, it is 
#'   the same as \code{informationRatesNew}.
#' 
#' @return A list with the following components: 
#' 
#' * \code{pvalue}: Repeated p-value for rejecting the null hypothesis.
#'  
#' * \code{thetahat}: Point estimate of the parameter.
#' 
#' * \code{cilevel}: Confidence interval level.
#' 
#' * \code{lower}: Lower bound of repeated confidence interval.
#' 
#' * \code{upper}: Upper bound of repeated confidence interval.
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references
#' Cyrus R. Mehta, Peter Bauer, Martin Posch and Werner Brannath.
#' Repeated confidence intervals for adaptive group sequential trials.
#' Stat Med. 2007;26:5422–5433.
#'
#' @seealso \code{\link{adaptDesign}}
#' 
#' @examples
#'
#' # original group sequential design with 90% power to detect delta = 6
#' delta = 6
#' sigma = 17
#' n = 282
#' (des1 = getDesign(IMax = n/(4*sigma^2), theta = delta, kMax = 3, 
#'                   alpha = 0.05, typeAlphaSpending = "sfHSD", 
#'                   parameterAlphaSpending = -4))
#' 
#' # interim look results
#' L = 1
#' n1 = n/3
#' delta1 = 4.5
#' sigma1 = 20
#' zL = delta1/sqrt(4/n1*sigma1^2)
#' 
#' t = des1$byStageResults$informationRates
#' 
#' # Muller & Schafer (2001) method to design the secondary trial: 
#' des2 = adaptDesign(
#'   betaNew = 0.2, L = L, zL = zL, theta = 5,
#'   kMax = 3, informationRates = t,
#'   alpha = 0.05, typeAlphaSpending = "sfHSD",
#'   parameterAlphaSpending = -4,
#'   MullerSchafer = TRUE,
#'   kNew = 3, typeAlphaSpendingNew = "sfHSD", 
#'   parameterAlphaSpendingNew = -2)
#' 
#' n2 = ceiling(des2$secondaryTrial$overallResults$maxInformation*4*20^2)
#' ns = round(n2*(1:3)/3)
#' (des2 = adaptDesign(
#'   INew = n2/(4*20^2), L = L, zL = zL, theta = 5,
#'   kMax = 3, informationRates = t,
#'   alpha = 0.05, typeAlphaSpending = "sfHSD",
#'   parameterAlphaSpending = -4,
#'   MullerSchafer = TRUE,
#'   kNew = 3, informationRatesNew = ns/n2,
#'   typeAlphaSpendingNew = "sfHSD",
#'   parameterAlphaSpendingNew = -2))
#' 
#' # termination at the second look of the secondary trial
#' L2 = 2
#' delta2 = 6.86
#' sigma2 = 21.77
#' zL2 = delta2/sqrt(4/197*sigma2^2)
#' 
#' t2 = des2$secondaryTrial$byStageResults$informationRates[1:L2]
#' 
#' # repeated confidence interval
#' getADRCI(L = L, zL = zL,
#'          IMax = n/(4*sigma1^2), kMax = 3,
#'          informationRates = t,
#'          alpha = 0.05, typeAlphaSpending = "sfHSD",
#'          parameterAlphaSpending = -4,
#'          L2 = L2, zL2 = zL2,
#'          INew = n2/(4*sigma2^2),
#'          MullerSchafer = TRUE,
#'          informationRatesNew = t2, 
#'          typeAlphaSpendingNew = "sfHSD",
#'          parameterAlphaSpendingNew = -2)
#' 
#' @export
getADRCI <- function(L = NA_integer_, zL = NA_real_, IMax = NA_real_, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.25, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, spendingTime = NA_real_, L2 = NA_integer_, zL2 = NA_real_, INew = NA_real_, MullerSchafer = 0L, informationRatesNew = NA_real_, efficacyStoppingNew = NA_integer_, typeAlphaSpendingNew = "sfOF", parameterAlphaSpendingNew = NA_real_, spendingTimeNew = NA_real_) {
    .Call(`_lrstat_getADRCI`, L, zL, IMax, kMax, informationRates, efficacyStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, spendingTime, L2, zL2, INew, MullerSchafer, informationRatesNew, efficacyStoppingNew, typeAlphaSpendingNew, parameterAlphaSpendingNew, spendingTimeNew)
}

#' @title Conditional power allowing for varying parameter values
#' @description Obtains the conditional power for specified incremental 
#' information given the interim results, parameter values, and 
#' data-dependent changes in the error spending function and the 
#' number and spacing of interim looks. 
#'
#' @param INew The maximum information of the secondary trial.
#' @param L The interim adaptation look of the primary trial.
#' @param zL The z-test statistic at the interim adaptation look of 
#'   the primary trial.
#' @param theta A scalar or a vector of parameter values of 
#'   length \code{kMax + kMax - L} if \code{MullerSchafer = FALSE} or 
#'   length \code{kMax + kNew} if \code{MullerSchafer = TRUE}.
#' @param IMax The maximum information of the primary trial.
#' @param kMax The maximum number of stages of the primary trial.
#' @param informationRates The information rates of the primary trial.
#' @param efficacyStopping Indicators of whether efficacy stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param futilityStopping Indicators of whether futility stopping is 
#'   allowed at each stage of the primary trial. Defaults to true 
#'   if left unspecified.
#' @param criticalValues The upper boundaries on the z-test statistic scale
#'   for efficacy stopping for the primary trial.
#' @param alpha The significance level of the primary trial. 
#'   Defaults to 0.025.
#' @param typeAlphaSpending The type of alpha spending for the primary 
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, 
#'   "user" for user defined spending, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpending The parameter value of alpha spending
#'   for the primary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param userAlphaSpending The user defined alpha spending for the primary 
#'   trial. Cumulative alpha spent up to each stage.
#' @param futilityBounds	The lower boundaries on the z-test statistic scale 
#'   for futility stopping for the primary trial. Defaults to 
#'   \code{rep(-6, kMax-1)} if left unspecified.
#' @param typeBetaSpending The type of beta spending for the primary trial. 
#'   One of the following: 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early futility stopping. 
#'   Defaults to "none".
#' @param parameterBetaSpending The parameter value of beta spending 
#'   for the primary trial. Corresponds to rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param spendingTime The error spending time of the primary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#' @param MullerSchafer Whether to use the Muller and Schafer (2001) method 
#'   for trial adaptation.
#' @param kNew The number of looks of the secondary trial.
#' @param informationRatesNew The spacing of looks of the secondary trial.
#' @param efficacyStoppingNew The indicators of whether efficacy stopping is 
#'   allowed at each look of the secondary trial. Defaults to true 
#'   if left unspecified.
#' @param futilityStoppingNew The indicators of whether futility stopping is 
#'   allowed at each look of the secondary trial. Defaults to true 
#'   if left unspecified.
#' @param typeAlphaSpendingNew The type of alpha spending for the secondary
#'   trial. One of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, 
#'   "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and 
#'   "none" for no early efficacy stopping. 
#'   Defaults to "sfOF".
#' @param parameterAlphaSpendingNew The parameter value of alpha spending 
#'   for the secondary trial. Corresponds to Delta for "WT", rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param typeBetaSpendingNew The type of beta spending for the secondary 
#'   trial. One of the following: 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function, 
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, and
#'   "none" for no early futility stopping. 
#'   Defaults to "none".
#' @param parameterBetaSpendingNew The parameter value of beta spending 
#'   for the secondary trial. Corresponds to rho for "sfKD", 
#'   and gamma for "sfHSD".
#' @param spendingTimeNew The error spending time of the secondary trial. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRatesNew}.
#'
#' @return The conditional power given the interim results, parameter 
#' values, and data-dependent design changes.
#' 
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#' 
#' @references 
#' Cyrus R. Mehta and Stuart J. Pocock. 
#' Adaptive increase in sample size when interim results are promising: 
#' A practical guide with examples.
#' Stat Med. 2011;30:3267–3284.
#'
#' @seealso \code{\link{getDesign}}
#' 
#' @examples
#' 
#' # Conditional power calculation with delayed treatment effect
#' 
#' # Two interim analyses have occurred with 179 and 266 events, respectively
#' # The observed hazard ratio at the second interim look is 0.81
#' 
#' trialsdt = as.Date("2020-03-04")                       # trial start date
#' iadt = c(as.Date("2022-02-01"), as.Date("2022-11-01")) # interim dates
#' mo1 = as.numeric(iadt - trialsdt + 1)/30.4375          # interim months
#' 
#' # Assume a piecewise Poisson enrollment process with a 8-month ramp-up and
#' # 521 patients were enrolled after 17.94 months
#' N = 521                   # total number of patients
#' Ta = 17.94                # enrollment duration
#' Ta1 = 8                   # assumed end of enrollment ramp-up
#' enrate = N / (Ta - Ta1/2) # enrollment rate after ramp-up
#' 
#' # Assume a median survival of 16.7 months for the control group, a 5-month
#' # delay in treatment effect, and a hazard ratio of 0.7 after the delay
#' lam1 = log(2)/16.7  # control group hazard of exponential distribution
#' t1 = 5              # months of delay in treatment effect
#' hr = 0.7            # hazard ratio after delay
#' lam2 = hr*lam1      # treatment group hazard after delay
#' 
#' # Assume an annual dropout rate of 5%
#' gam = -log(1-0.05)/12  # hazard for dropout
#' 
#' # The original target number of events was 298 and the new target is 335
#' mo2 <- caltime(
#'   nevents = c(298, 335),
#'   allocationRatioPlanned = 1,
#'   accrualTime = seq(0, Ta1), 
#'   accrualIntensity = enrate*seq(1, Ta1+1)/(Ta1+1),
#'   piecewiseSurvivalTime = c(0, t1),
#'   lambda1 = c(lam1, lam2),
#'   lambda2 = c(lam1, lam1),
#'   gamma1 = gam,
#'   gamma2 = gam,
#'   accrualDuration = Ta,
#'   followupTime = 1000)
#' 
#' # expected number of events and average hazard ratios
#' (lr1 <- lrstat(
#'   time = c(mo1, mo2),
#'   accrualTime = seq(0, Ta1), 
#'   accrualIntensity = enrate*seq(1, Ta1+1)/(Ta1+1),
#'   piecewiseSurvivalTime = c(0, t1),
#'   lambda1 = c(lam1, lam2),
#'   lambda2 = c(lam1, lam1),
#'   gamma1 = gam,
#'   gamma2 = gam,
#'   accrualDuration = Ta,
#'   followupTime = 1000,
#'   predictTarget = 3))
#' 
#' 
#' hr2 = 0.81                    # observed hazard ratio at interim 2
#' z2 = (-log(hr2))*sqrt(266/4)  # corresponding z-test statistic value
#'  
#' # expected mean of -log(HR) at the original looks and the new final look
#' theta = -log(lr1$HR[c(1,2,3,4)])
#' 
#' # conditional power with sample size increase
#' getCP(INew = (335 - 266)/4, 
#'       L = 2, zL = z2, theta = theta,
#'       IMax = 298/4, kMax = 3, 
#'       informationRates = c(179, 266, 298)/298,
#'       alpha = 0.025, typeAlphaSpending = "sfOF")
#'
#' @export
getCP <- function(INew = NA_real_, L = NA_integer_, zL = NA_real_, theta = NA_real_, IMax = NA_real_, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, spendingTime = NA_real_, MullerSchafer = 0L, kNew = NA_integer_, informationRatesNew = NA_real_, efficacyStoppingNew = NA_integer_, futilityStoppingNew = NA_integer_, typeAlphaSpendingNew = "sfOF", parameterAlphaSpendingNew = NA_real_, typeBetaSpendingNew = "none", parameterBetaSpendingNew = NA_real_, spendingTimeNew = NA_real_) {
    .Call(`_lrstat_getCP`, INew, L, zL, theta, IMax, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, spendingTime, MullerSchafer, kNew, informationRatesNew, efficacyStoppingNew, futilityStoppingNew, typeAlphaSpendingNew, parameterAlphaSpendingNew, typeBetaSpendingNew, parameterBetaSpendingNew, spendingTimeNew)
}

ftrunccpp <- function(p, test, gamma) {
    .Call(`_lrstat_ftrunccpp`, p, test, gamma)
}

set_seed <- function(seed) {
    invisible(.Call(`_lrstat_set_seed`, seed))
}

stl_sort <- function(x) {
    .Call(`_lrstat_stl_sort`, x)
}

#' @title Find interval numbers of indices
#' @description The implementation of \code{findInterval()} in R from Advanced
#' R by Hadley Wickham. Given a vector of non-decreasing breakpoints in v,
#' find the interval containing each element of x; i.e., if
#' \code{i <- findInterval2(x,v)}, for each index \code{j} in \code{x},
#' \code{v[i[j]] <= x[j] < v[i[j] + 1]}, where \code{v[0] := -Inf}, 
#' \code{v[N+1] := +Inf}, and \code{N = length(v)}.
#'
#' @param x The numeric vector of interest.
#' @param v The vector of break points.
#' @return A vector of \code{length(x)} with values in \code{0:N} where
#'   \code{N = length(v)}.
#'
#' @keywords internal
#'
#' @author Kaifeng Lu, \email{kaifenglu@@gmail.com}
#'
#' @examples
#' x <- 2:18
#' v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
#' cbind(x, findInterval2(x, v))
#'
#' @export
findInterval2 <- function(x, v) {
    .Call(`_lrstat_findInterval2`, x, v)
}

errorSpentcpp <- function(t, error, sf, sfpar) {
    .Call(`_lrstat_errorSpentcpp`, t, error, sf, sfpar)
}

exitprobcpp <- function(b, a, theta, I) {
    .Call(`_lrstat_exitprobcpp`, b, a, theta, I)
}

qtpwexpcpp <- function(probability, piecewiseSurvivalTime, lambda, lowerBound) {
    .Call(`_lrstat_qtpwexpcpp`, probability, piecewiseSurvivalTime, lambda, lowerBound)
}

getBoundcpp <- function(k, informationRates, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, spendingTime, efficacyStopping) {
    .Call(`_lrstat_getBoundcpp`, k, informationRates, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, spendingTime, efficacyStopping)
}

getPower <- function(alpha, kMax, b, theta, I, bsf, bsfpar, st, futilityStopping) {
    .Call(`_lrstat_getPower`, alpha, kMax, b, theta, I, bsf, bsfpar, st, futilityStopping)
}

