% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLMetaData_as.R
\name{as_header}
\alias{as_header}
\title{Coerce LPJmLMetaData to an LPJmL header object}
\usage{
as_header(x, silent = FALSE)
}
\arguments{
\item{x}{An \link{LPJmLMetaData} object}

\item{silent}{Logical. Whether to suppress notifications from header
conversion/initialization.}
}
\value{
An LPJmL header object. More information at \code{\link[=create_header]{create_header()}}.
}
\description{
Function to coerce (convert) an \code{\link{LPJmLMetaData}} object into an
LPJmL header object. More information at \code{\link[=create_header]{create_header()}}.
}
\examples{
\dontrun{

vegc_meta <- read_meta(filename = "./vegc.bin.json")

# Returns a list object with the structure of an LPJmL header
as_header(vegc_meta)
# $name
# [1] "LPJDUMMY"
#
# $header
#      version        order    firstyear        nyear    firstcell
#          4.0          4.0       1901.0        200.0          0.0
#        ncell       nbands cellsize_lon       scalar cellsize_lat
#      67420.0          1.0          0.5          1.0          0.5
#     datatype        nstep     timestep
#          3.0          1.0          1.0
#
# $endian
# [1] "little"

}

}
