% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity-package.R
\docType{package}
\name{lpdensity-package}
\alias{lpdensity-package}
\alias{_PACKAGE}
\title{lpdensity: Local Polynomial Density Estimation and Inference}
\description{
Without imposing stringent distributional assumptions or shape restrictions,
  nonparametric density estimation has been popular in economics and other social
  sciences for counterfactual analysis, program evaluation, and policy recommendations.
  This package implements a novel density estimator based on local polynomial
  regression, documented in Cattaneo, Jansson and Ma (2019a): \code{\link{lpdensity}}
  to construct local polynomial based density estimator, \code{\link{lpbwdensity}}
  to perform data-driven bandwidth selection, and \code{\link{lpdensity.plot}} for
  density plot with robust confidence interval.

  The companion software article, Cattaneo, Jansson and Ma (2019b),
  provides further implementation details and illustrations with simulated data.
  For related \code{Stata}
  and \code{R} packages useful for nonparametric data analysis  and statistical inference,
  visit \url{https://sites.google.com/site/nppackages/}.
}
\references{
M.D. Cattaneo, M. Jansson and X. Ma. (2019a). \href{https://arxiv.org/abs/1811.11512}{Simple Local Polynomial Density Estimators}. \emph{Journal of the American Statistical Association}, forthcoming.

M.D. Cattaneo, M. Jansson and X. Ma. (2019b). \href{https://arxiv.org/abs/1906.06529}{\code{lpdensity}: Local Polynomial Density Estimation and Inference}. Working paper.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
