##################################################################################################
##                                                                                              ##
##    lossDev is an R-package.                                                                  ##
##    It is a Bayesian time series model of loss development.                                   ##
##    Features include skewed Student-t distribution with time-varying scale parameters,        ##
##    an expert prior for the calendar year effect,                                             ##
##    and accommodation for structural breaks in the consumption path of services.              ##
##                                                                                              ##
##    Copyright  2009, 2010, 2011 National Council On Compensation Insurance Inc.,             ##
##                                                                                              ##
##    This file is part of lossDev.                                                             ##
##                                                                                              ##
##    lossDev is free software: you can redistribute it and/or modify                           ##
##    it under the terms of the GNU General Public License as published by                      ##
##    the Free Software Foundation, either version 3 of the License, or                         ##
##    (at your option) any later version.                                                       ##
##                                                                                              ##
##    This program is distributed in the hope that it will be useful,                           ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of                            ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                             ##
##    GNU General Public License for more details.                                              ##
##                                                                                              ##
##    You should have received a copy of the GNU General Public License                         ##
##    along with this program.  If not, see <http://www.gnu.org/licenses/>.                     ##
##                                                                                              ##
##################################################################################################


##' A package for robust stochastic loss development.
##'
##' \pkg{lossDev} makes available a Bayesian time series model of loss development, estimated using MCMC.
##' Features include skewed Student-t distribution with time-varying scale parameter, expert prior for the calendar year effect, and structural break in the consumption path of services.
##'
##' Please read the vignette for guidance on usage.  And \dQuote{Robust Loss Development Using MCMC} by Schmid, Frank A. for theory.
##'
##' @references Schmid, Frank A., \dQuote{Robust Loss Development Using MCMC,}, 2009
##' @name lossDev
##' @docType package
NULL
