% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_rectangle}
\alias{l_layer_rectangle}
\title{Layer a rectangle}
\usage{
l_layer_rectangle(
  widget,
  x,
  y,
  color = "gray80",
  linecolor = "black",
  linewidth = 1,
  label = "rectangle",
  parent = "root",
  index = 0,
  ...
)
}
\arguments{
\item{widget}{widget path name as a string}

\item{x}{x coordinates}

\item{y}{y coordinates}

\item{color}{fill color, if empty string \code{""}, then the fill is transparant}

\item{linecolor}{outline color}

\item{linewidth}{linewidth of outline}

\item{label}{label used in the layers inspector}

\item{parent}{group layer}

\item{index}{of the newly added layer in its parent group}

\item{...}{additional state initialization arguments, see
\code{\link{l_info_states}}}
}
\value{
layer object handle, layer id
}
\description{
Loon's displays that are based on Cartesian coordinates (i.e.
  scatterplot, histogram and graph display) allow for layering visual
  information including polygons, text and rectangles.
}
\details{
For more information run: \code{l_help("learn_R_layer")}
}
\examples{
if(interactive()){

p <- l_plot()
l <- l_layer_rectangle(p, x=c(2,3), y=c(1,10), color='steelblue')
l_scaleto_layer(l)

}
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_info_states}}
}
