% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_state}
\alias{l_bind_state}
\title{Add a state change binding}
\usage{
l_bind_state(target, event, callback)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{event}{vector with state names}

\item{callback}{callback function is an R function which is called by the Tcl
interpreter if the event of interest happens. Note that in loon the 
callback functions support different optional arguments depending on the
binding type, read the details for more information}
}
\value{
state change binding id
}
\description{
The callback of a state change binding is evaluated when certain
  states change, as specified at binding creation.
}
\details{
Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\seealso{
\code{\link{l_info_states}}, \code{\link{l_bind_state_ids}},
  \code{\link{l_bind_state_get}}, \code{\link{l_bind_state_delete}},
  \code{\link{l_bind_state_reorder}}
}
